/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.url;

import com.helger.base.codec.DecodeException;
import com.helger.base.codec.impl.URLCodec;
import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class URLCoder {
    public static final Charset CHARSET_URL_OBJ = StandardCharsets.UTF_8;
    private static final URLCodec URL_CODEC = new URLCodec();

    private URLCoder() {
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string) {
        return URLCoder.urlDecode(string, CHARSET_URL_OBJ);
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        try {
            return URL_CODEC.getDecodedAsString(string, charset);
        }
        catch (DecodeException decodeException) {
            throw new IllegalArgumentException(decodeException);
        }
    }

    @Nullable
    public static String urlDecodeOrNull(@Nonnull String string) {
        return URLCoder.urlDecodeOrNull(string, CHARSET_URL_OBJ);
    }

    @Nullable
    public static String urlDecodeOrNull(@Nullable String string, @Nonnull Charset charset) {
        return URLCoder.urlDecodeOrDefault(string, charset, null);
    }

    @Nullable
    public static String urlDecodeOrDefault(@Nonnull String string, @Nullable String string2) {
        return URLCoder.urlDecodeOrDefault(string, CHARSET_URL_OBJ, string2);
    }

    @Nullable
    public static String urlDecodeOrDefault(@Nullable String string, @Nonnull Charset charset, @Nullable String string2) {
        if (string != null) {
            try {
                return URL_CODEC.getDecodedAsString(string, charset);
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
        return string2;
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string) {
        return URLCoder.urlEncode(string, CHARSET_URL_OBJ);
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        return URL_CODEC.getEncodedAsString(string, charset);
    }
}

