/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.url;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.IDecoder;
import com.helger.base.codec.IEncoder;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.url.IURLProtocol;
import com.helger.collection.CollectionHelper;
import com.helger.http.url.ISimpleURL;
import com.helger.http.url.URLData;
import com.helger.http.url.URLParameter;
import com.helger.http.url.URLParameterEncoder;
import com.helger.http.url.URLParameterList;
import com.helger.http.url.URLProtocolRegistry;
import com.helger.io.url.URLHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SimpleURLHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleURLHelper.class);

    private SimpleURLHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static URLParameterList getParsedQueryParameters(@Nullable String string) {
        return SimpleURLHelper.getParsedQueryParameters(string, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static URLParameterList getParsedQueryParameters(@Nullable String string, @Nullable IDecoder<String, String> iDecoder) {
        URLParameterList uRLParameterList = new URLParameterList();
        if (StringHelper.isNotEmpty((String)string)) {
            for (String string2 : StringHelper.getExploded((char)'&', (String)string)) {
                String string3;
                List list;
                String string4;
                if (string2.length() <= 0 || !StringHelper.isNotEmpty((String)(string4 = (String)(list = StringHelper.getExploded((char)'=', (String)string2, (int)2)).get(0)))) continue;
                String string5 = string3 = list.size() == 2 ? (String)list.get(1) : "";
                if (string3 == null) {
                    throw new IllegalArgumentException("parameter value may not be null");
                }
                if (iDecoder != null) {
                    uRLParameterList.add((String)iDecoder.getDecoded((Object)string4), (String)iDecoder.getDecoded((Object)string3));
                    continue;
                }
                uRLParameterList.add(string4, string3);
            }
        }
        return uRLParameterList;
    }

    @Nonnull
    public static ISimpleURL getAsURLData(@Nonnull String string) {
        return SimpleURLHelper.getAsURLData(string, null);
    }

    @Nonnull
    public static ISimpleURL getAsURLData(@Nonnull String string, @Nullable IDecoder<String, String> iDecoder) {
        String string2;
        String string3;
        ValueEnforcer.notNull((Object)string, (String)"Href");
        String string4 = string.trim();
        IURLProtocol iURLProtocol = URLProtocolRegistry.getInstance().getProtocol(string4);
        if (iURLProtocol != null && !iURLProtocol.allowsForQueryParameters()) {
            return new URLData(string4, null, null);
        }
        if (GlobalDebug.isDebugMode() && iURLProtocol != null) {
            try {
                new URL(string4);
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.warn("java.net.URL claims URL '" + string4 + "' to be invalid: " + malformedURLException.getMessage());
            }
        }
        URLParameterList uRLParameterList = null;
        String string5 = string4;
        int n = string5.indexOf(35);
        if (n >= 0) {
            string3 = string5.substring(n + 1).trim();
            string5 = string5.substring(0, n).trim();
        } else {
            string3 = null;
        }
        int n2 = string5.indexOf(63);
        if (n2 >= 0) {
            String string6 = string5.substring(n2 + 1).trim();
            if (StringHelper.isNotEmpty((String)string6)) {
                uRLParameterList = SimpleURLHelper.getParsedQueryParameters(string6, iDecoder);
            }
            string2 = string5.substring(0, n2).trim();
        } else {
            string2 = string5;
        }
        return new URLData(string2, uRLParameterList, string3);
    }

    @Nullable
    public static String getQueryParametersAsString(@Nullable List<? extends URLParameter> list, @Nullable IEncoder<String, String> iEncoder) {
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (URLParameter uRLParameter : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            uRLParameter.appendTo(stringBuilder, iEncoder);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getURLString(@Nonnull ISimpleURL iSimpleURL, @Nullable Charset charset) {
        return SimpleURLHelper.getURLString(iSimpleURL.getPath(), (List<? extends URLParameter>)((Object)iSimpleURL.params()), iSimpleURL.getAnchor(), charset);
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable List<? extends URLParameter> list, @Nullable String string2, @Nullable IEncoder<String, String> iEncoder) {
        return URLHelper.getURLString((String)string, (String)SimpleURLHelper.getQueryParametersAsString(list, iEncoder), (String)string2);
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable List<? extends URLParameter> list, @Nullable String string2, @Nullable Charset charset) {
        URLParameterEncoder uRLParameterEncoder = charset == null ? null : new URLParameterEncoder(charset);
        return URLHelper.getURLString((String)string, (String)SimpleURLHelper.getQueryParametersAsString(list, uRLParameterEncoder), (String)string2);
    }
}

