/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.url;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.iface.IHasSize;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.http.url.ISimpleURL;
import com.helger.http.url.IURLParameterList;
import com.helger.http.url.SimpleURLHelper;
import com.helger.http.url.URLCoder;
import com.helger.http.url.URLData;
import com.helger.http.url.URLParameter;
import com.helger.http.url.URLParameterDecoder;
import com.helger.http.url.URLParameterList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

@NotThreadSafe
public class SimpleURL
implements ISimpleURL,
ICloneable<SimpleURL>,
IURLParameterList<SimpleURL> {
    private String m_sPath;
    private final URLParameterList m_aParams = new URLParameterList();
    private String m_sAnchor;

    public SimpleURL() {
        this(URLData.EMPTY_URL_DATA);
    }

    public SimpleURL(@Nonnull URL uRL) {
        this(uRL, URLCoder.CHARSET_URL_OBJ);
    }

    public SimpleURL(@Nonnull URL uRL, @Nonnull Charset charset) {
        this(uRL.toExternalForm(), charset);
    }

    public SimpleURL(@Nonnull URI uRI) {
        this(uRI, URLCoder.CHARSET_URL_OBJ);
    }

    public SimpleURL(@Nonnull URI uRI, @Nonnull Charset charset) {
        this(uRI.toString(), charset);
    }

    public SimpleURL(@Nonnull String string) {
        this(string, URLCoder.CHARSET_URL_OBJ);
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset) {
        this(SimpleURLHelper.getAsURLData(string, new URLParameterDecoder(charset)));
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map) {
        this(string);
        this.m_aParams.addAll(map);
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map, @Nullable String string2) {
        this(string, URLCoder.CHARSET_URL_OBJ, map, string2);
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset, @Nullable Map<String, String> map, @Nullable String string2) {
        this(string, charset);
        this.m_aParams.addAll(map);
        this.m_sAnchor = string2;
    }

    public SimpleURL(@Nonnull String string, @Nullable Iterable<? extends URLParameter> iterable, @Nullable String string2) {
        this(string, URLCoder.CHARSET_URL_OBJ, iterable, string2);
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset, @Nullable Iterable<? extends URLParameter> iterable, @Nullable String string2) {
        this(string, charset);
        this.m_aParams.addAll(iterable);
        this.m_sAnchor = string2;
    }

    public SimpleURL(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        this.m_sPath = iSimpleURL.getPath();
        this.m_aParams.addAll((List)((Object)iSimpleURL.params()));
        this.m_sAnchor = iSimpleURL.getAnchor();
    }

    @Override
    @Nonnull
    public final String getPath() {
        return this.m_sPath;
    }

    @Nonnull
    public SimpleURL setPath(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Path");
        this.m_sPath = string;
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final URLParameterList params() {
        return this.m_aParams;
    }

    @Override
    public boolean add(@Nonnull URLParameter uRLParameter) {
        return this.m_aParams.add(uRLParameter);
    }

    @Override
    @Nullable
    public final String getAnchor() {
        return this.m_sAnchor;
    }

    @Nonnull
    public SimpleURL setAnchor(@Nullable String string) {
        this.m_sAnchor = string;
        return this;
    }

    @Nonnull
    public SimpleURL getClone() {
        return new SimpleURL(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SimpleURL simpleURL = (SimpleURL)object;
        String string = this.m_sAnchor;
        return this.m_sPath.equals(simpleURL.m_sPath) && this.m_aParams.equals(simpleURL.m_aParams) && EqualsHelper.equals((Object)string, (Object)simpleURL.m_sAnchor);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPath).append((Object)this.m_aParams).append((Object)this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Path", (Object)this.m_sPath).appendIf("Params", (Object)this.m_aParams, IHasSize::isNotEmpty).appendIfNotNull("Anchor", (Object)this.m_sAnchor).getToString();
    }
}

