/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.url;

import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.url.IURLProtocol;
import com.helger.http.url.SimpleURLHelper;
import com.helger.http.url.URLCoder;
import com.helger.http.url.URLParameterList;
import com.helger.http.url.URLProtocolRegistry;
import com.helger.io.url.URLHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;

public interface ISimpleURL {
    @Nullable
    default public IURLProtocol getProtocol() {
        return URLProtocolRegistry.getInstance().getProtocol(this.getPath());
    }

    default public boolean hasKnownProtocol() {
        return URLProtocolRegistry.getInstance().hasKnownProtocol(this.getPath());
    }

    @Nonnull
    public String getPath();

    @Nullable
    @ReturnsMutableObject
    public URLParameterList params();

    @Nullable
    public String getAnchor();

    default public boolean hasAnchor() {
        return StringHelper.isNotEmpty((String)this.getAnchor());
    }

    default public boolean hasAnchor(@Nullable String string) {
        return EqualsHelper.equals((Object)string, (Object)this.getAnchor());
    }

    @Nonnull
    default public String getAsStringWithoutEncodedParameters() {
        return SimpleURLHelper.getURLString(this, null);
    }

    @Nonnull
    default public String getAsStringWithEncodedParameters() {
        return SimpleURLHelper.getURLString(this, URLCoder.CHARSET_URL_OBJ);
    }

    @Nonnull
    default public String getAsStringWithEncodedParameters(@Nonnull Charset charset) {
        return SimpleURLHelper.getURLString(this, charset);
    }

    @Nullable
    default public URL getAsURL() {
        return URLHelper.getAsURL((String)this.getAsStringWithEncodedParameters());
    }

    @Nullable
    default public URI getAsURI() {
        return URLHelper.getAsURI((String)this.getAsStringWithEncodedParameters());
    }
}

