/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsSet;
import com.helger.graph.IBaseGraphNode;
import com.helger.graph.IDirectedGraphRelation;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@MustImplementEqualsAndHashcode
public interface IDirectedGraphNode<NODETYPE extends IDirectedGraphNode<NODETYPE, RELATIONTYPE>, RELATIONTYPE extends IDirectedGraphRelation<NODETYPE, RELATIONTYPE>>
extends IBaseGraphNode<NODETYPE, RELATIONTYPE> {
    public boolean hasIncomingRelations();

    @Nonnegative
    public int getIncomingRelationCount();

    public boolean isIncomingRelation(@Nullable RELATIONTYPE var1);

    @ReturnsMutableCopy
    public @NonNull ICommonsList<RELATIONTYPE> getAllIncomingRelations();

    public void forEachIncomingRelation(@NonNull Consumer<? super RELATIONTYPE> var1);

    public boolean isFromNode(@Nullable NODETYPE var1);

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<NODETYPE> getAllFromNodes();

    public @Nullable RELATIONTYPE getIncomingRelationFrom(@Nullable NODETYPE var1);

    public boolean hasOutgoingRelations();

    @Nonnegative
    public int getOutgoingRelationCount();

    public boolean isOutgoingRelation(@Nullable RELATIONTYPE var1);

    @ReturnsMutableCopy
    public @NonNull ICommonsList<RELATIONTYPE> getAllOutgoingRelations();

    public void forEachOutgoingRelation(@NonNull Consumer<? super RELATIONTYPE> var1);

    public boolean isToNode(@Nullable NODETYPE var1);

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<NODETYPE> getAllToNodes();

    public @Nullable RELATIONTYPE getOutgoingRelationTo(@Nullable NODETYPE var1);

    default public boolean hasIncomingOrOutgoingRelations() {
        return this.hasIncomingRelations() || this.hasOutgoingRelations();
    }

    default public boolean hasIncomingAndOutgoingRelations() {
        return this.hasIncomingRelations() && this.hasOutgoingRelations();
    }

    @Override
    default public boolean hasRelations() {
        return this.hasIncomingOrOutgoingRelations();
    }

    @Override
    @Nonnegative
    default public int getRelationCount() {
        return this.getIncomingRelationCount() + this.getOutgoingRelationCount();
    }

    @Override
    default public void forEachRelation(@NonNull Consumer<? super RELATIONTYPE> consumer) {
        this.forEachIncomingRelation(consumer);
        this.forEachOutgoingRelation(consumer);
    }
}

