/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.graph.IMutableGraphNode;
import com.helger.graph.IMutableGraphRelation;
import com.helger.graph.impl.AbstractBaseGraphObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.function.Consumer;

@NotThreadSafe
public class GraphNode
extends AbstractBaseGraphObject
implements IMutableGraphNode {
    private ICommonsOrderedMap<String, IMutableGraphRelation> m_aRelations;

    public GraphNode() {
        this(null);
    }

    public GraphNode(@Nullable String string) {
        super(string);
    }

    @Override
    public final boolean isDirected() {
        return false;
    }

    @Override
    @Nonnull
    public EChange addRelation(@Nullable IMutableGraphRelation iMutableGraphRelation) {
        if (iMutableGraphRelation == null) {
            return EChange.UNCHANGED;
        }
        if (!iMutableGraphRelation.isRelatedTo(this)) {
            throw new IllegalArgumentException("Relation is not suitable for this node!");
        }
        String string = (String)iMutableGraphRelation.getID();
        if (this.m_aRelations == null) {
            this.m_aRelations = new CommonsLinkedHashMap();
        } else if (this.m_aRelations.containsKey((Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_aRelations.put((Object)string, (Object)iMutableGraphRelation);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange removeRelation(@Nullable IMutableGraphRelation iMutableGraphRelation) {
        if (iMutableGraphRelation == null || this.m_aRelations == null) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aRelations.remove(iMutableGraphRelation.getID()) != null ? 1 : 0) != 0);
    }

    @Override
    @Nonnull
    public EChange removeAllRelations() {
        if (!this.hasRelations()) {
            return EChange.UNCHANGED;
        }
        this.m_aRelations = null;
        return EChange.CHANGED;
    }

    @Override
    public boolean isConnectedWith(@Nullable IMutableGraphNode iMutableGraphNode) {
        return this.getRelation(iMutableGraphNode) != null;
    }

    @Override
    @Nullable
    public IMutableGraphRelation getRelation(@Nullable IMutableGraphNode iMutableGraphNode) {
        if (this.m_aRelations != null && iMutableGraphNode != null && iMutableGraphNode != this) {
            for (IMutableGraphRelation iMutableGraphRelation : this.m_aRelations.values()) {
                if (!iMutableGraphRelation.isRelatedTo(iMutableGraphNode)) continue;
                return iMutableGraphRelation;
            }
        }
        return null;
    }

    @Override
    public boolean hasRelations() {
        return this.m_aRelations != null && this.m_aRelations.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getRelationCount() {
        return this.m_aRelations == null ? 0 : this.m_aRelations.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMutableGraphRelation> getAllRelations() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        if (this.m_aRelations != null) {
            commonsLinkedHashSet.addAll(this.m_aRelations.values());
        }
        return commonsLinkedHashSet;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllRelationIDs() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        if (this.m_aRelations != null) {
            commonsLinkedHashSet.addAll((Collection)this.m_aRelations.keySet());
        }
        return commonsLinkedHashSet;
    }

    @Override
    public void forEachRelation(@Nonnull Consumer<? super IMutableGraphRelation> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        if (this.m_aRelations != null) {
            this.m_aRelations.forEachValue(consumer);
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMutableGraphNode> getAllRelatedNodes() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        if (this.m_aRelations != null) {
            for (IMutableGraphRelation iMutableGraphRelation : this.m_aRelations.values()) {
                commonsLinkedHashSet.add((Object)iMutableGraphRelation.getNode1());
                commonsLinkedHashSet.add((Object)iMutableGraphRelation.getNode2());
            }
        }
        return commonsLinkedHashSet;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllRelatedNodeIDs() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        if (this.m_aRelations != null) {
            for (IMutableGraphRelation iMutableGraphRelation : this.m_aRelations.values()) {
                commonsLinkedHashSet.add((Object)iMutableGraphRelation.getNode1ID());
                commonsLinkedHashSet.add((Object)iMutableGraphRelation.getNode2ID());
            }
        }
        return commonsLinkedHashSet;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("relationIDs", this.m_aRelations == null ? null : this.m_aRelations.keySet()).getToString();
    }
}

