/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.id.factory.IIDFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@ThreadSafe
public final class GraphObjectIDFactory {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IIDFactory<String> s_aIDFactory;
    private static final GraphObjectIDFactory INSTANCE;

    private GraphObjectIDFactory() {
    }

    @Nullable
    public static IIDFactory<String> getIDFactory() {
        return (IIDFactory)RW_LOCK.readLockedGet(() -> s_aIDFactory);
    }

    public static void setIDFactory(@Nullable IIDFactory<String> iIDFactory) {
        RW_LOCK.writeLocked(() -> {
            s_aIDFactory = iIDFactory;
        });
    }

    @Nonnull
    @Nonempty
    public static String createNewGraphObjectID() {
        return (String)RW_LOCK.readLockedGet(() -> s_aIDFactory != null ? (String)s_aIDFactory.getNewID() : GlobalIDFactory.getNewStringID());
    }

    static {
        INSTANCE = new GraphObjectIDFactory();
    }
}

