/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.graph.IMutableBaseGraph;
import com.helger.graph.IMutableBaseGraphNode;
import com.helger.graph.IMutableBaseGraphRelation;
import com.helger.graph.impl.AbstractBaseGraphObject;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractBaseGraph<NODETYPE extends IMutableBaseGraphNode<NODETYPE, RELATIONTYPE>, RELATIONTYPE extends IMutableBaseGraphRelation<NODETYPE, RELATIONTYPE>>
extends AbstractBaseGraphObject
implements IMutableBaseGraph<NODETYPE, RELATIONTYPE> {
    public static final boolean DEFAULT_CHANGING_CONNECTED_OBJECTS_ALLOWED = true;
    protected final ICommonsOrderedMap<String, NODETYPE> m_aNodes = new CommonsLinkedHashMap();
    private boolean m_bIsChangingConnectedObjectsAllowed = true;

    protected AbstractBaseGraph(@Nullable String string) {
        super(string);
    }

    @Override
    public void setChangingConnectedObjectsAllowed(boolean bl) {
        this.m_bIsChangingConnectedObjectsAllowed = bl;
    }

    @Override
    public boolean isChangingConnectedObjectsAllowed() {
        return this.m_bIsChangingConnectedObjectsAllowed;
    }

    @Override
    @Nullable
    public NODETYPE getNodeOfID(@Nullable String string) {
        return (NODETYPE)((IMutableBaseGraphNode)this.m_aNodes.get((Object)string));
    }

    @Override
    @Nonnegative
    public int getNodeCount() {
        return this.m_aNodes.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, NODETYPE> getAllNodes() {
        return this.m_aNodes.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllNodeIDs() {
        return this.m_aNodes.copyOfKeySet();
    }

    @Override
    public void forEachNode(@Nonnull Consumer<? super NODETYPE> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        this.m_aNodes.values().forEach(consumer);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractBaseGraph abstractBaseGraph = (AbstractBaseGraph)object;
        return this.m_aNodes.equals(abstractBaseGraph.m_aNodes) && this.m_bIsChangingConnectedObjectsAllowed == abstractBaseGraph.m_bIsChangingConnectedObjectsAllowed;
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aNodes).append(this.m_bIsChangingConnectedObjectsAllowed).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("nodes", this.m_aNodes).append("isChangingConnectedObjectsAllowed", this.m_bIsChangingConnectedObjectsAllowed).getToString();
    }
}

