/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.commons.state.IChangeIndicator;
import com.helger.graph.IMutableGraph;
import com.helger.graph.IMutableGraphNode;
import com.helger.graph.IMutableGraphObjectFactory;
import com.helger.graph.IMutableGraphRelation;
import com.helger.graph.impl.AbstractBaseGraph;
import com.helger.graph.iterate.GraphIterator;
import com.helger.matrix.Matrix;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Graph
extends AbstractBaseGraph<IMutableGraphNode, IMutableGraphRelation>
implements IMutableGraph {
    private final IMutableGraphObjectFactory m_aFactory;
    private ETriState m_eCacheHasCycles = ETriState.UNDEFINED;

    public Graph(@Nullable String string, @Nonnull IMutableGraphObjectFactory iMutableGraphObjectFactory) {
        super(string);
        ValueEnforcer.notNull((Object)iMutableGraphObjectFactory, (String)"Factory");
        this.m_aFactory = iMutableGraphObjectFactory;
    }

    @Override
    public final boolean isDirected() {
        return false;
    }

    private void _invalidateCache() {
        this.m_eCacheHasCycles = ETriState.UNDEFINED;
    }

    @Override
    @Nonnull
    public IMutableGraphNode createNode() {
        IMutableGraphNode iMutableGraphNode = this.m_aFactory.createNode();
        if (this.addNode(iMutableGraphNode).isUnchanged()) {
            throw new IllegalStateException("The ID factory created the ID '" + (String)iMutableGraphNode.getID() + "' that is already in use");
        }
        return iMutableGraphNode;
    }

    @Override
    @Nullable
    public IMutableGraphNode createNode(@Nullable String string) {
        IMutableGraphNode iMutableGraphNode = this.m_aFactory.createNode(string);
        return this.addNode(iMutableGraphNode).isChanged() ? iMutableGraphNode : null;
    }

    @Override
    @Nonnull
    public EChange addNode(@Nonnull IMutableGraphNode iMutableGraphNode) {
        ValueEnforcer.notNull((Object)iMutableGraphNode, (String)"Node");
        if (!this.isChangingConnectedObjectsAllowed() && iMutableGraphNode.hasRelations()) {
            throw new IllegalArgumentException("The node to be added already has incoming and/or outgoing relations and this is not allowed!");
        }
        String string = (String)iMutableGraphNode.getID();
        if (this.m_aNodes.containsKey((Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_aNodes.put((Object)string, (Object)iMutableGraphNode);
        this._invalidateCache();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange removeNode(@Nonnull IMutableGraphNode iMutableGraphNode) {
        ValueEnforcer.notNull((Object)iMutableGraphNode, (String)"Node");
        if (!this.isChangingConnectedObjectsAllowed() && iMutableGraphNode.hasRelations()) {
            throw new IllegalArgumentException("The node to be removed already has incoming and/or outgoing relations and this is not allowed!");
        }
        if (this.m_aNodes.remove(iMutableGraphNode.getID()) == null) {
            return EChange.UNCHANGED;
        }
        this._invalidateCache();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange removeNodeAndAllRelations(@Nonnull IMutableGraphNode iMutableGraphNode) {
        ValueEnforcer.notNull((Object)iMutableGraphNode, (String)"Node");
        if (!this.m_aNodes.containsKey(iMutableGraphNode.getID())) {
            return EChange.UNCHANGED;
        }
        for (IMutableGraphRelation iMutableGraphRelation : iMutableGraphNode.getAllRelations()) {
            for (IMutableGraphNode iMutableGraphNode2 : iMutableGraphRelation.getAllConnectedNodes()) {
                iMutableGraphNode2.removeRelation(iMutableGraphRelation);
            }
        }
        if (this.removeNode(iMutableGraphNode).isUnchanged()) {
            throw new IllegalStateException("Inconsistency removing node and all relations");
        }
        return EChange.CHANGED;
    }

    @Nonnull
    private IMutableGraphRelation _connect(@Nonnull IMutableGraphRelation iMutableGraphRelation) {
        EChange eChange = EChange.UNCHANGED;
        for (IMutableGraphNode iMutableGraphNode : iMutableGraphRelation.getAllConnectedNodes()) {
            eChange = eChange.or((IChangeIndicator)iMutableGraphNode.addRelation(iMutableGraphRelation));
        }
        if (eChange.isChanged()) {
            this._invalidateCache();
        }
        return iMutableGraphRelation;
    }

    @Override
    @Nonnull
    public IMutableGraphRelation createRelation(@Nonnull IMutableGraphNode iMutableGraphNode, @Nonnull IMutableGraphNode iMutableGraphNode2) {
        return this._connect(this.m_aFactory.createRelation(iMutableGraphNode, iMutableGraphNode2));
    }

    @Override
    @Nonnull
    public IMutableGraphRelation createRelation(@Nullable String string, @Nonnull IMutableGraphNode iMutableGraphNode, @Nonnull IMutableGraphNode iMutableGraphNode2) {
        return this._connect(this.m_aFactory.createRelation(string, iMutableGraphNode, iMutableGraphNode2));
    }

    @Override
    @Nonnull
    public EChange removeRelation(@Nullable IMutableGraphRelation iMutableGraphRelation) {
        EChange eChange = EChange.UNCHANGED;
        if (iMutableGraphRelation != null) {
            for (IMutableGraphNode iMutableGraphNode : iMutableGraphRelation.getAllConnectedNodes()) {
                eChange = eChange.or((IChangeIndicator)iMutableGraphNode.removeRelation(iMutableGraphRelation));
            }
            if (eChange.isChanged()) {
                this._invalidateCache();
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, IMutableGraphRelation> getAllRelations() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (IMutableGraphNode iMutableGraphNode : this.m_aNodes.values()) {
            iMutableGraphNode.forEachRelation(arg_0 -> Graph.lambda$getAllRelations$0((ICommonsOrderedMap)commonsLinkedHashMap, arg_0));
        }
        return commonsLinkedHashMap;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMutableGraphRelation> getAllRelationObjs() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IMutableGraphNode iMutableGraphNode : this.m_aNodes.values()) {
            iMutableGraphNode.forEachRelation(arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        }
        return commonsArrayList;
    }

    @Override
    public void forEachRelation(@Nonnull Consumer<? super IMutableGraphRelation> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        for (IMutableGraphNode iMutableGraphNode : this.m_aNodes.values()) {
            iMutableGraphNode.forEachRelation(consumer);
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllRelationIDs() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        for (IMutableGraphNode iMutableGraphNode : this.m_aNodes.values()) {
            commonsLinkedHashSet.addAll(iMutableGraphNode.getAllRelationIDs());
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    public EChange removeAll() {
        if (this.m_aNodes.removeAll().isUnchanged()) {
            return EChange.UNCHANGED;
        }
        this._invalidateCache();
        return EChange.CHANGED;
    }

    @Override
    public boolean containsCycles() {
        if (this.m_eCacheHasCycles.isUndefined()) {
            this.m_eCacheHasCycles = ETriState.FALSE;
            ICommonsList iCommonsList = this.m_aNodes.copyOfValues();
            while (iCommonsList.isNotEmpty()) {
                GraphIterator graphIterator = new GraphIterator((IMutableGraphNode)iCommonsList.removeFirstOrNull());
                if (graphIterator.hasCycles()) {
                    this.m_eCacheHasCycles = ETriState.TRUE;
                    break;
                }
                while (graphIterator.hasNext()) {
                    iCommonsList.remove((Object)graphIterator.next());
                }
            }
        }
        return this.m_eCacheHasCycles.getAsBooleanValue(true);
    }

    @Override
    public boolean isSelfContained() {
        for (IMutableGraphNode iMutableGraphNode : this.m_aNodes.values()) {
            for (IMutableGraphRelation iMutableGraphRelation : iMutableGraphNode.getAllRelations()) {
                for (IMutableGraphNode iMutableGraphNode2 : iMutableGraphRelation.getAllConnectedNodes()) {
                    if (this.m_aNodes.containsKey(iMutableGraphNode2.getID())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public Matrix createIncidenceMatrix() {
        int n = this.getNodeCount();
        Matrix matrix = new Matrix(n, n, 0.0);
        IMutableGraphNode[] iMutableGraphNodeArray = this.m_aNodes.values().toArray(new IMutableGraphNode[n]);
        for (int i = 0; i < n; ++i) {
            IMutableGraphNode iMutableGraphNode = iMutableGraphNodeArray[i];
            for (int j = 0; j < n; ++j) {
                if (i == j || !iMutableGraphNode.isConnectedWith(iMutableGraphNodeArray[j])) continue;
                matrix.set(i, j, 1.0);
                matrix.set(j, i, 1.0);
            }
        }
        return matrix;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static /* synthetic */ void lambda$getAllRelations$0(ICommonsOrderedMap iCommonsOrderedMap, IMutableGraphRelation iMutableGraphRelation) {
        iCommonsOrderedMap.put((Object)((String)iMutableGraphRelation.getID()), (Object)iMutableGraphRelation);
    }
}

