/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.state.IClearable;
import com.helger.graph.IBaseGraphNode;
import com.helger.graph.IBaseGraphObject;
import com.helger.graph.IBaseGraphRelation;
import com.helger.matrix.Matrix;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IBaseGraph<NODETYPE extends IBaseGraphNode<NODETYPE, RELATIONTYPE>, RELATIONTYPE extends IBaseGraphRelation<NODETYPE, RELATIONTYPE>>
extends IBaseGraphObject,
IClearable {
    @Nonnegative
    public int getNodeCount();

    @Nullable
    public NODETYPE getNodeOfID(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, NODETYPE> getAllNodes();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllNodeIDs();

    public void forEachNode(@Nonnull Consumer<? super NODETYPE> var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, RELATIONTYPE> getAllRelations();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<RELATIONTYPE> getAllRelationObjs();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllRelationIDs();

    public void forEachRelation(@Nonnull Consumer<? super RELATIONTYPE> var1);

    public boolean containsCycles();

    public boolean isSelfContained();

    @Nonnull
    public Matrix createIncidenceMatrix();
}

