/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.error.text;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.text.IHasErrorText;
import com.helger.text.IHasText;
import com.helger.text.display.IHasDisplayText;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
@MustImplementEqualsAndHashcode
public class DynamicHasErrorText
implements IHasErrorText {
    private final IHasText m_aText;

    public DynamicHasErrorText(@NonNull IHasDisplayText iHasDisplayText) {
        this(iHasDisplayText.getAsHasText());
    }

    public DynamicHasErrorText(@NonNull IHasText iHasText) {
        this.m_aText = (IHasText)ValueEnforcer.notNull((Object)iHasText, (String)"Text");
    }

    public @Nullable String getDisplayText(@NonNull Locale locale) {
        return this.m_aText.getText(locale);
    }

    @Override
    public boolean isMultiLingual() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DynamicHasErrorText dynamicHasErrorText = (DynamicHasErrorText)object;
        return EqualsHelper.equals((Object)this.m_aText, (Object)dynamicHasErrorText.m_aText);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("MLT", (Object)this.m_aText).getToString();
    }
}

