/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.log;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.level.IHasErrorLevelComparable;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class LogMessage
implements IHasErrorLevelComparable<LogMessage> {
    private final LocalDateTime m_aIssueDT;
    private final IErrorLevel m_aErrorLevel;
    private final Serializable m_aMsg;
    private final Throwable m_aThrowable;

    public LogMessage(@NonNull LocalDateTime localDateTime, @NonNull IErrorLevel iErrorLevel, @NonNull Serializable serializable, @Nullable Throwable throwable) {
        this.m_aIssueDT = (LocalDateTime)ValueEnforcer.notNull((Object)localDateTime, (String)"IssueDT");
        this.m_aErrorLevel = (IErrorLevel)ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        this.m_aMsg = (Serializable)ValueEnforcer.notNull((Object)serializable, (String)"Message");
        this.m_aThrowable = throwable;
    }

    public @NonNull LocalDateTime getIssueDateTime() {
        return this.m_aIssueDT;
    }

    @Override
    public @NonNull IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    public @NonNull Serializable getMessage() {
        return this.m_aMsg;
    }

    public @Nullable Throwable getThrowable() {
        return this.m_aThrowable;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("issueDT", (Object)this.m_aIssueDT).append("errorLevel", (Object)this.m_aErrorLevel).append("msg", (Object)this.m_aMsg).appendIfNotNull("throwable", (Object)this.m_aThrowable).getToString();
    }
}

