/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.log;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.level.IHasErrorLevel;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class LogHelper {
    private static final LogHelper INSTANCE = new LogHelper();

    private LogHelper() {
    }

    public static @NonNull IFuncIsLoggingEnabled getFuncIsEnabled(@NonNull Logger logger, @NonNull IErrorLevel iErrorLevel) {
        ValueEnforcer.notNull((Object)logger, (String)"Logger");
        ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        if (iErrorLevel.isGE(EErrorLevel.ERROR)) {
            return () -> ((Logger)logger).isErrorEnabled();
        }
        if (iErrorLevel.isGE(EErrorLevel.WARN)) {
            return () -> ((Logger)logger).isWarnEnabled();
        }
        if (iErrorLevel.isGE(EErrorLevel.INFO)) {
            return () -> ((Logger)logger).isInfoEnabled();
        }
        return () -> ((Logger)logger).isDebugEnabled();
    }

    public static @NonNull IFuncLogger getFuncLogger(@NonNull Logger logger, @NonNull IErrorLevel iErrorLevel) {
        ValueEnforcer.notNull((Object)logger, (String)"Logger");
        ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        if (iErrorLevel.isGE(EErrorLevel.ERROR)) {
            return (arg_0, arg_1) -> ((Logger)logger).error(arg_0, arg_1);
        }
        if (iErrorLevel.isGE(EErrorLevel.WARN)) {
            return (arg_0, arg_1) -> ((Logger)logger).warn(arg_0, arg_1);
        }
        if (iErrorLevel.isGE(EErrorLevel.INFO)) {
            return (arg_0, arg_1) -> ((Logger)logger).info(arg_0, arg_1);
        }
        return (arg_0, arg_1) -> ((Logger)logger).debug(arg_0, arg_1);
    }

    public static boolean isEnabled(@NonNull Class<?> clazz, @NonNull IHasErrorLevel iHasErrorLevel) {
        return LogHelper.isEnabled(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel());
    }

    public static boolean isEnabled(@NonNull Logger logger, @NonNull IHasErrorLevel iHasErrorLevel) {
        return LogHelper.isEnabled(logger, iHasErrorLevel.getErrorLevel());
    }

    public static boolean isEnabled(@NonNull Class<?> clazz, @NonNull IErrorLevel iErrorLevel) {
        return LogHelper.isEnabled(LoggerFactory.getLogger(clazz), iErrorLevel);
    }

    public static boolean isEnabled(@NonNull Logger logger, @NonNull IErrorLevel iErrorLevel) {
        return LogHelper.getFuncIsEnabled(logger, iErrorLevel).isEnabled();
    }

    public static void log(@NonNull Class<?> clazz, @NonNull IHasErrorLevel iHasErrorLevel, @NonNull String string) {
        LogHelper.log(clazz, iHasErrorLevel.getErrorLevel(), string, null);
    }

    public static void log(@NonNull Class<?> clazz, @NonNull IHasErrorLevel iHasErrorLevel, @NonNull String string, @Nullable Throwable throwable) {
        LogHelper.log(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel(), string, throwable);
    }

    public static void log(@NonNull Logger logger, @NonNull IHasErrorLevel iHasErrorLevel, @NonNull String string) {
        LogHelper.log(logger, iHasErrorLevel.getErrorLevel(), string, null);
    }

    public static void log(@NonNull Logger logger, @NonNull IHasErrorLevel iHasErrorLevel, @NonNull String string, @Nullable Throwable throwable) {
        LogHelper.log(logger, iHasErrorLevel.getErrorLevel(), string, throwable);
    }

    public static void log(@NonNull Class<?> clazz, @NonNull IErrorLevel iErrorLevel, @NonNull String string) {
        LogHelper.log(clazz, iErrorLevel, string, null);
    }

    public static void log(@NonNull Class<?> clazz, @NonNull IErrorLevel iErrorLevel, @NonNull String string, @Nullable Throwable throwable) {
        LogHelper.log(LoggerFactory.getLogger(clazz), iErrorLevel, string, throwable);
    }

    public static void log(@NonNull Logger logger, @NonNull IErrorLevel iErrorLevel, @NonNull String string) {
        LogHelper.log(logger, iErrorLevel, string, null);
    }

    public static void log(@NonNull Logger logger, @NonNull IErrorLevel iErrorLevel, @NonNull String string, @Nullable Throwable throwable) {
        ValueEnforcer.notNull((Object)logger, (String)"Logger");
        ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        ValueEnforcer.notNull((Object)string, (String)"Message");
        if (LogHelper.isEnabled(logger, iErrorLevel)) {
            LogHelper.getFuncLogger(logger, iErrorLevel).log(string, throwable);
        }
    }

    public static void log(@NonNull Class<?> clazz, @NonNull IHasErrorLevel iHasErrorLevel, @NonNull Supplier<String> supplier) {
        LogHelper.log(clazz, iHasErrorLevel.getErrorLevel(), supplier, null);
    }

    public static void log(@NonNull Class<?> clazz, @NonNull IHasErrorLevel iHasErrorLevel, @NonNull Supplier<String> supplier, @Nullable Throwable throwable) {
        LogHelper.log(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel(), supplier, throwable);
    }

    public static void log(@NonNull Logger logger, @NonNull IHasErrorLevel iHasErrorLevel, @NonNull Supplier<String> supplier) {
        LogHelper.log(logger, iHasErrorLevel.getErrorLevel(), supplier, null);
    }

    public static void log(@NonNull Logger logger, @NonNull IHasErrorLevel iHasErrorLevel, @NonNull Supplier<String> supplier, @Nullable Throwable throwable) {
        LogHelper.log(logger, iHasErrorLevel.getErrorLevel(), supplier, throwable);
    }

    public static void log(@NonNull Class<?> clazz, @NonNull IErrorLevel iErrorLevel, @NonNull Supplier<String> supplier) {
        LogHelper.log(clazz, iErrorLevel, supplier, null);
    }

    public static void log(@NonNull Class<?> clazz, @NonNull IErrorLevel iErrorLevel, @NonNull Supplier<String> supplier, @Nullable Throwable throwable) {
        LogHelper.log(LoggerFactory.getLogger(clazz), iErrorLevel, supplier, throwable);
    }

    public static void log(@NonNull Logger logger, @NonNull IErrorLevel iErrorLevel, @NonNull Supplier<String> supplier) {
        LogHelper.log(logger, iErrorLevel, supplier, null);
    }

    public static void log(@NonNull Logger logger, @NonNull IErrorLevel iErrorLevel, @NonNull Supplier<String> supplier, @Nullable Throwable throwable) {
        ValueEnforcer.notNull((Object)logger, (String)"Logger");
        ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        ValueEnforcer.notNull(supplier, (String)"MessageSupplier");
        if (LogHelper.isEnabled(logger, iErrorLevel)) {
            LogHelper.getFuncLogger(logger, iErrorLevel).log(supplier.get(), throwable);
        }
    }

    @FunctionalInterface
    public static interface IFuncIsLoggingEnabled {
        public boolean isEnabled();
    }

    @FunctionalInterface
    public static interface IFuncLogger {
        public void log(@NonNull String var1, @Nullable Throwable var2);
    }
}

