/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.log;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EChange;
import com.helger.base.state.IClearable;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.level.IHasErrorLevels;
import com.helger.diagnostics.log.LogMessage;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class InMemoryLogger
implements IHasErrorLevels<LogMessage>,
IClearable {
    private final ICommonsList<LogMessage> m_aMessages = new CommonsArrayList();

    @OverrideOnDemand
    protected @NonNull LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now(Clock.systemDefaultZone());
    }

    @OverrideOnDemand
    protected @Nullable LogMessage createLogMessage(@NonNull IErrorLevel iErrorLevel, @NonNull Serializable serializable, @Nullable Throwable throwable) {
        return new LogMessage(this.getCurrentLocalDateTime(), iErrorLevel, serializable, throwable);
    }

    @OverrideOnDemand
    protected void onAddLogMessage(@NonNull LogMessage logMessage) {
    }

    public void log(@NonNull IErrorLevel iErrorLevel, @NonNull Serializable serializable) {
        this.log(iErrorLevel, serializable, null);
    }

    public void log(@NonNull IErrorLevel iErrorLevel, @NonNull Serializable serializable, @Nullable Throwable throwable) {
        LogMessage logMessage = this.createLogMessage(iErrorLevel, serializable, throwable);
        if (logMessage != null) {
            this.m_aMessages.add((Object)logMessage);
            this.onAddLogMessage(logMessage);
        }
    }

    public void error(@NonNull Serializable serializable) {
        this.error(serializable, null);
    }

    public void error(@NonNull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.ERROR, serializable, throwable);
    }

    public void warn(@NonNull Serializable serializable) {
        this.warn(serializable, null);
    }

    public void warn(@NonNull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.WARN, serializable, throwable);
    }

    public void info(@NonNull Serializable serializable) {
        this.log(EErrorLevel.INFO, serializable, null);
    }

    public void info(@NonNull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.INFO, serializable, throwable);
    }

    public void success(@NonNull Serializable serializable) {
        this.log(EErrorLevel.SUCCESS, serializable, null);
    }

    public void success(@NonNull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.SUCCESS, serializable, throwable);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<LogMessage> getAllMessages() {
        return (ICommonsList)this.m_aMessages.getClone();
    }

    public @NonNull Iterator<LogMessage> iterator() {
        return this.m_aMessages.iterator();
    }

    @Nonnegative
    public int size() {
        return this.m_aMessages.size();
    }

    public boolean isEmpty() {
        return this.m_aMessages.isEmpty();
    }

    public @NonNull EChange removeAll() {
        return this.m_aMessages.removeAll();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("messages", this.m_aMessages).getToString();
    }
}

