/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.error;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.location.ILocation;
import com.helger.base.location.SimpleLocation;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.AbstractSingleErrorBuilder;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.SingleErrorBuilder;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.text.IHasErrorText;
import java.time.LocalDateTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class SingleError
implements IError {
    private final LocalDateTime m_aErrorDT;
    private final IErrorLevel m_aErrorLevel;
    private final String m_sErrorID;
    private final String m_sErrorFieldName;
    private final ILocation m_aErrorLocation;
    private final IHasErrorText m_aErrorText;
    private final Throwable m_aLinkedException;

    protected SingleError(@NonNull AbstractSingleErrorBuilder<?, ?> abstractSingleErrorBuilder) {
        this(abstractSingleErrorBuilder.m_aErrorDT, abstractSingleErrorBuilder.m_aErrorLevel, abstractSingleErrorBuilder.m_sErrorID, abstractSingleErrorBuilder.m_sErrorFieldName, abstractSingleErrorBuilder.m_aErrorLocation, abstractSingleErrorBuilder.m_aErrorText, abstractSingleErrorBuilder.m_aLinkedException);
    }

    public SingleError(@Nullable LocalDateTime localDateTime, @NonNull IErrorLevel iErrorLevel, @Nullable String string, @Nullable String string2, @Nullable ILocation iLocation, @Nullable IHasErrorText iHasErrorText, @Nullable Throwable throwable) {
        this.m_aErrorDT = localDateTime;
        this.m_aErrorLevel = (IErrorLevel)ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        this.m_sErrorID = string;
        this.m_sErrorFieldName = string2;
        this.m_aErrorLocation = iLocation != null ? iLocation : SimpleLocation.NO_LOCATION;
        this.m_aErrorText = iHasErrorText;
        this.m_aLinkedException = throwable;
    }

    @Override
    public @Nullable LocalDateTime getErrorDateTime() {
        return this.m_aErrorDT;
    }

    @Override
    public @NonNull IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Override
    public @Nullable String getErrorID() {
        return this.m_sErrorID;
    }

    @Override
    public @Nullable String getErrorFieldName() {
        return this.m_sErrorFieldName;
    }

    @Override
    public @NonNull ILocation getErrorLocation() {
        return this.m_aErrorLocation;
    }

    @Override
    public @Nullable IHasErrorText getErrorTexts() {
        return this.m_aErrorText;
    }

    @Override
    public @Nullable Throwable getLinkedException() {
        return this.m_aLinkedException;
    }

    @OverrideOnDemand
    protected boolean equalsLinkedException(@Nullable Throwable throwable, @Nullable Throwable throwable2) {
        if (EqualsHelper.identityEqual((Object)throwable, (Object)throwable2)) {
            return true;
        }
        if (throwable == null || throwable2 == null) {
            return false;
        }
        return throwable.getClass().equals(throwable2.getClass()) && EqualsHelper.equals((Object)throwable.getMessage(), (Object)throwable2.getMessage());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleError singleError = (SingleError)object;
        return EqualsHelper.equals((Object)this.m_aErrorDT, (Object)singleError.m_aErrorDT) && this.m_aErrorLevel.equals(singleError.m_aErrorLevel) && EqualsHelper.equals((Object)this.m_sErrorID, (Object)singleError.m_sErrorID) && EqualsHelper.equals((Object)this.m_sErrorFieldName, (Object)singleError.m_sErrorFieldName) && EqualsHelper.equals((Object)this.m_aErrorLocation, (Object)singleError.m_aErrorLocation) && EqualsHelper.equals((Object)this.m_aErrorText, (Object)singleError.m_aErrorText) && this.equalsLinkedException(this.m_aLinkedException, singleError.m_aLinkedException);
    }

    @OverrideOnDemand
    protected void hashCodeLinkedException(@NonNull HashCodeGenerator hashCodeGenerator, @Nullable Throwable throwable) {
        if (throwable == null) {
            hashCodeGenerator.append(129);
        } else {
            hashCodeGenerator.append(throwable.getClass()).append((Object)throwable.getMessage());
        }
    }

    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator((Object)this).append((Object)this.m_aErrorDT).append((Object)this.m_aErrorLevel).append((Object)this.m_sErrorID).append((Object)this.m_sErrorFieldName).append((Object)this.m_aErrorLocation).append((Object)this.m_aErrorText);
        this.hashCodeLinkedException(hashCodeGenerator, this.m_aLinkedException);
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("ErrorDateTime", (Object)this.m_aErrorDT).append("ErrorLevel", (Object)this.m_aErrorLevel).appendIfNotNull("ErrorID", (Object)this.m_sErrorID).appendIfNotNull("ErrorFieldName", (Object)this.m_sErrorFieldName).appendIfNotNull("ErrorLocation", (Object)this.m_aErrorLocation).appendIfNotNull("ErrorText", (Object)this.m_aErrorText).appendIfNotNull("LinkedException", (Object)this.m_aLinkedException).getToString();
    }

    public static @NonNull SingleErrorBuilder builder() {
        return new SingleErrorBuilder();
    }

    public static @NonNull SingleErrorBuilder builder(@NonNull IError iError) {
        return new SingleErrorBuilder(iError);
    }

    public static @NonNull SingleErrorBuilder builderSuccess() {
        return (SingleErrorBuilder)SingleError.builder().errorLevel(EErrorLevel.SUCCESS);
    }

    public static @NonNull SingleErrorBuilder builderInfo() {
        return (SingleErrorBuilder)SingleError.builder().errorLevel(EErrorLevel.INFO);
    }

    public static @NonNull SingleErrorBuilder builderWarn() {
        return (SingleErrorBuilder)SingleError.builder().errorLevel(EErrorLevel.WARN);
    }

    public static @NonNull SingleErrorBuilder builderError() {
        return (SingleErrorBuilder)SingleError.builder().errorLevel(EErrorLevel.ERROR);
    }

    public static @NonNull SingleErrorBuilder builderFatalError() {
        return (SingleErrorBuilder)SingleError.builder().errorLevel(EErrorLevel.FATAL_ERROR);
    }
}

