/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.datetime.format.EDTFormatterMode;
import com.helger.datetime.format.PDTFormatter;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.datetime.xml.XMLOffsetTime;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PDTFromString {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDTFromString.class);
    private static final PDTFromString INSTANCE = new PDTFromString();

    private PDTFromString() {
    }

    private static void _onParseException(@NonNull String string, @NonNull String string2, @Nullable DateTimeFormatter dateTimeFormatter, @NonNull DateTimeParseException dateTimeParseException) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Failed to parse " + string + " '" + string2 + "'" + (String)(dateTimeFormatter == null ? "" : " with " + String.valueOf(dateTimeFormatter)) + ": " + dateTimeParseException.getMessage());
        }
    }

    public static @Nullable ZonedDateTime getZonedDateTimeFromString(@Nullable String string, @NonNull String string2) {
        return PDTFromString.getZonedDateTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    public static @Nullable ZonedDateTime getZonedDateTimeFromString(@Nullable String string, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"DateTimeFormatter");
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, ZonedDateTime::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("ZonedDateTime", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    public static @Nullable OffsetDateTime getOffsetDateTimeFromString(@Nullable String string, @NonNull String string2) {
        return PDTFromString.getOffsetDateTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    public static @Nullable OffsetDateTime getOffsetDateTimeFromString(@Nullable String string, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"DateTimeFormatter");
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, OffsetDateTime::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("OffsetDateTime", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    public static @Nullable XMLOffsetDateTime getXMLOffsetDateTimeFromString(@Nullable String string, @NonNull String string2) {
        return PDTFromString.getXMLOffsetDateTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    public static @Nullable XMLOffsetDateTime getXMLOffsetDateTimeFromString(@Nullable String string, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"DateTimeFormatter");
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, XMLOffsetDateTime::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("XMLOffsetDateTime", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    public static @Nullable LocalDate getLocalDateFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getLocalDateFromString(string, PDTFormatter.getFormatterDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PARSE));
    }

    public static @Nullable LocalDate getLocalDateFromString(@Nullable String string, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"DateTimeFormatter");
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, LocalDate::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("LocalDate", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    public static @Nullable LocalDate getLocalDateFromString(@Nullable String string, @NonNull String string2) {
        return PDTFromString.getLocalDateFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    public static @Nullable OffsetDate getOffsetDateFromString(@Nullable String string, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"DateTimeFormatter");
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, OffsetDate::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("OffsetDate", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    public static @Nullable OffsetDate getOffsetDateFromString(@Nullable String string, @NonNull String string2) {
        return PDTFromString.getOffsetDateFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    public static @Nullable XMLOffsetDate getXMLOffsetDateFromString(@Nullable String string, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"DateTimeFormatter");
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, XMLOffsetDate::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("XMLOffsetDate", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    public static @Nullable XMLOffsetDate getXMLOffsetDateFromString(@Nullable String string, @NonNull String string2) {
        return PDTFromString.getXMLOffsetDateFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    public static @Nullable LocalDateTime getLocalDateTimeFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getLocalDateTimeFromString(string, PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PARSE));
    }

    public static @Nullable LocalDateTime getLocalDateTimeFromString(@Nullable String string, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"DateTimeFormatter");
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, LocalDateTime::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("LocalDateTime", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    public static @Nullable LocalDateTime getLocalDateTimeFromString(@Nullable String string, @NonNull String string2) {
        return PDTFromString.getLocalDateTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    public static @Nullable LocalTime getLocalTimeFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getLocalTimeFromString(string, PDTFormatter.getFormatterTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PARSE));
    }

    public static @Nullable LocalTime getLocalTimeFromString(@Nullable String string, @NonNull String string2) {
        return PDTFromString.getLocalTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    public static @Nullable LocalTime getLocalTimeFromString(@Nullable String string, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"DateTimeFormatter");
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, LocalTime::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("LocalTime", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    public static @Nullable OffsetTime getOffsetTimeFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getOffsetTimeFromString(string, PDTFormatter.getFormatterTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PARSE));
    }

    public static @Nullable OffsetTime getOffsetTimeFromString(@Nullable String string, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"DateTimeFormatter");
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, OffsetTime::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("OffsetTime", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    public static @Nullable OffsetTime getOffsetTimeFromString(@Nullable String string, @NonNull String string2) {
        return PDTFromString.getOffsetTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    public static @Nullable XMLOffsetTime getXMLOffsetTimeFromString(@Nullable String string, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"DateTimeFormatter");
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, XMLOffsetTime::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("XMLOffsetTime", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    public static @Nullable XMLOffsetTime getXMLOffsetTimeFromString(@Nullable String string, @NonNull String string2) {
        return PDTFromString.getXMLOffsetTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    public static @Nullable Duration getDurationFromString(@Nullable String string) {
        try {
            return Duration.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            PDTFromString._onParseException("Duration", string, null, dateTimeParseException);
            return null;
        }
    }

    public static @Nullable Period getPeriodFromString(@Nullable String string) {
        try {
            return Period.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            PDTFromString._onParseException("Period", string, null, dateTimeParseException);
            return null;
        }
    }
}

