/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.period;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.domain.IHasStartAndEnd;
import com.helger.datetime.helper.PDTFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

public interface ILocalDateTimePeriod
extends IHasStartAndEnd<LocalDateTime> {
    public static boolean isInside(@Nullable LocalDateTime localDateTime, boolean bl, @Nullable LocalDateTime localDateTime2, boolean bl2, @Nonnull LocalDateTime localDateTime3) {
        ValueEnforcer.notNull((Object)localDateTime3, (String)"QueryDT");
        if (localDateTime != null && (bl ? localDateTime3.compareTo(localDateTime) < 0 : localDateTime3.compareTo(localDateTime) <= 0)) {
            return false;
        }
        return localDateTime2 == null || !(bl2 ? localDateTime3.compareTo(localDateTime2) > 0 : localDateTime3.compareTo(localDateTime2) >= 0);
    }

    default public boolean isInPeriod(boolean bl, @Nonnull LocalDateTime localDateTime) {
        return ILocalDateTimePeriod.isInside((LocalDateTime)this.getStart(), bl, (LocalDateTime)this.getEnd(), bl, localDateTime);
    }

    default public boolean isInPeriodIncl(@Nonnull LocalDateTime localDateTime) {
        return this.isInPeriod(true, localDateTime);
    }

    default public boolean isNowInPeriodIncl() {
        return this.isInPeriodIncl(PDTFactory.getCurrentLocalDateTime());
    }

    default public boolean isInPeriodExcl(@Nonnull LocalDateTime localDateTime) {
        return this.isInPeriod(false, localDateTime);
    }

    default public boolean isNowInPeriodExcl() {
        return this.isInPeriodExcl(PDTFactory.getCurrentLocalDateTime());
    }

    public static boolean hasOverlap(@Nullable LocalDateTime localDateTime, @Nullable LocalDateTime localDateTime2, @Nullable LocalDateTime localDateTime3, @Nullable LocalDateTime localDateTime4, boolean bl) {
        if (localDateTime3 != null && ILocalDateTimePeriod.isInside(localDateTime, bl, localDateTime2, bl, localDateTime3)) {
            return true;
        }
        if (localDateTime4 != null && ILocalDateTimePeriod.isInside(localDateTime, bl, localDateTime2, bl, localDateTime4)) {
            return true;
        }
        if (localDateTime != null && ILocalDateTimePeriod.isInside(localDateTime3, bl, localDateTime4, bl, localDateTime)) {
            return true;
        }
        return localDateTime2 != null && ILocalDateTimePeriod.isInside(localDateTime3, bl, localDateTime4, bl, localDateTime2);
    }

    default public boolean isOverlappingWith(@Nonnull ILocalDateTimePeriod iLocalDateTimePeriod, boolean bl) {
        return ILocalDateTimePeriod.hasOverlap((LocalDateTime)this.getStart(), (LocalDateTime)this.getEnd(), (LocalDateTime)iLocalDateTimePeriod.getStart(), (LocalDateTime)iLocalDateTimePeriod.getEnd(), bl);
    }

    default public boolean isOverlappingWithIncl(@Nonnull ILocalDateTimePeriod iLocalDateTimePeriod) {
        return this.isOverlappingWith(iLocalDateTimePeriod, true);
    }

    default public boolean isOverlappingWithExcl(@Nonnull ILocalDateTimePeriod iLocalDateTimePeriod) {
        return this.isOverlappingWith(iLocalDateTimePeriod, false);
    }
}

