/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.util;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.numeric.MathHelper;
import com.helger.collection.commons.CommonsArrayList;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;

@Immutable
public final class PDTDisplayHelper {
    private static final PDTDisplayHelper INSTANCE = new PDTDisplayHelper();

    private PDTDisplayHelper() {
    }

    @Nonnull
    @Nonempty
    public static String getPeriodText(int n, int n2, int n3, long l, long l2, long l3, @Nonnull IPeriodTextProvider iPeriodTextProvider) {
        String string = iPeriodTextProvider.getYears(n);
        String string2 = iPeriodTextProvider.getMonths(n2);
        String string3 = iPeriodTextProvider.getDays(n3);
        String string4 = iPeriodTextProvider.getHours(l);
        String string5 = iPeriodTextProvider.getMinutes(l2);
        String string6 = iPeriodTextProvider.getSeconds(l3);
        CommonsArrayList commonsArrayList = new CommonsArrayList(6);
        if (n != 0) {
            commonsArrayList.add((Object)string);
        }
        if (n2 != 0 || commonsArrayList.isNotEmpty()) {
            commonsArrayList.add((Object)string2);
        }
        if (n3 != 0 || commonsArrayList.isNotEmpty()) {
            commonsArrayList.add((Object)string3);
        }
        if (l != 0L || commonsArrayList.isNotEmpty()) {
            commonsArrayList.add((Object)string4);
        }
        if (l2 != 0L || commonsArrayList.isNotEmpty()) {
            commonsArrayList.add((Object)string5);
        }
        commonsArrayList.add((Object)string6);
        int n4 = commonsArrayList.size();
        if (n4 == 1) {
            return (String)commonsArrayList.get(0);
        }
        if (n4 == 2) {
            return (String)commonsArrayList.get(0) + iPeriodTextProvider.getAnd() + (String)commonsArrayList.get(1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n4 - 1; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(iPeriodTextProvider.getComma());
            }
            stringBuilder.append((String)commonsArrayList.get(i));
        }
        return stringBuilder.append(iPeriodTextProvider.getAnd()).append((String)commonsArrayList.getLastOrNull()).toString();
    }

    @Nonnull
    @Nonempty
    public static String getPeriodText(@Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2, @Nonnull IPeriodTextProvider iPeriodTextProvider) {
        Period period = Period.between(localDateTime.toLocalDate(), localDateTime2.toLocalDate());
        Duration duration = Duration.between(localDateTime.toLocalTime(), localDateTime2.toLocalTime());
        int n = period.getYears();
        int n2 = period.getMonths();
        int n3 = period.getDays();
        long l = duration.getSeconds();
        if (l < 0L && (n3 > 0 || n2 > 0 || n > 0)) {
            l += 86400L;
            --n3;
        }
        long l2 = l / 3600L;
        long l3 = (l -= l2 * 3600L) / 60L;
        return PDTDisplayHelper.getPeriodText(n, n2, n3, l2, l3, l -= l3 * 60L, iPeriodTextProvider);
    }

    @Nonnull
    @Nonempty
    public static String getPeriodTextDE(@Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2) {
        return PDTDisplayHelper.getPeriodText(localDateTime, localDateTime2, IPeriodTextProvider.DE);
    }

    @Nonnull
    @Nonempty
    public static String getPeriodTextEN(@Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2) {
        return PDTDisplayHelper.getPeriodText(localDateTime, localDateTime2, IPeriodTextProvider.EN);
    }

    public static interface IPeriodTextProvider {
        public static final IPeriodTextProvider EN = new IPeriodTextProvider(){};
        public static final IPeriodTextProvider DE = new IPeriodTextProvider(){

            @Override
            @Nonnull
            @Nonempty
            public String getYears(@CheckForSigned int n) {
                return MathHelper.abs((int)n) == 1 ? n + " Jahr" : n + " Jahre";
            }

            @Override
            @Nonnull
            @Nonempty
            public String getMonths(@CheckForSigned int n) {
                return MathHelper.abs((int)n) == 1 ? n + " Monat" : n + " Monate";
            }

            @Override
            @Nonnull
            @Nonempty
            public String getDays(@CheckForSigned int n) {
                return MathHelper.abs((int)n) == 1 ? n + " Tag" : n + " Tage";
            }

            @Override
            @Nonnull
            @Nonempty
            public String getHours(@CheckForSigned long l) {
                return MathHelper.abs((long)l) == 1L ? l + " Stunde" : l + " Stunden";
            }

            @Override
            @Nonnull
            @Nonempty
            public String getMinutes(@CheckForSigned long l) {
                return MathHelper.abs((long)l) == 1L ? l + " Minute" : l + " Minuten";
            }

            @Override
            @Nonnull
            @Nonempty
            public String getSeconds(@CheckForSigned long l) {
                return MathHelper.abs((long)l) == 1L ? l + " Sekunde" : l + " Sekunden";
            }

            @Override
            @Nonnull
            public String getAnd() {
                return " und ";
            }
        };

        @Nonnull
        @Nonempty
        default public String getYears(@CheckForSigned int n) {
            return MathHelper.abs((int)n) == 1 ? n + " year" : n + " years";
        }

        @Nonnull
        @Nonempty
        default public String getMonths(@CheckForSigned int n) {
            return MathHelper.abs((int)n) == 1 ? n + " month" : n + " months";
        }

        @Nonnull
        @Nonempty
        default public String getDays(@CheckForSigned int n) {
            return MathHelper.abs((int)n) == 1 ? n + " day" : n + " days";
        }

        @Nonnull
        @Nonempty
        default public String getHours(@CheckForSigned long l) {
            return MathHelper.abs((long)l) == 1L ? l + " hour" : l + " hours";
        }

        @Nonnull
        @Nonempty
        default public String getMinutes(@CheckForSigned long l) {
            return MathHelper.abs((long)l) == 1L ? l + " minute" : l + " minutes";
        }

        @Nonnull
        @Nonempty
        default public String getSeconds(@CheckForSigned long l) {
            return MathHelper.abs((long)l) == 1L ? l + " second" : l + " seconds";
        }

        @Nonnull
        default public String getAnd() {
            return " and ";
        }

        @Nonnull
        default public String getComma() {
            return ", ";
        }
    }
}

