/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;

@ThreadSafe
@DevelopersNote(value="The mutable m_nHashCode does not contradict thread safety")
public final class DateTimeFormatterPattern {
    private final String m_sPattern;
    private final ResolverStyle m_eResolverStyle;
    private final DateTimeFormatter m_aFormatter;
    private int m_nHashCode = 0;

    public DateTimeFormatterPattern(@Nonnull @Nonempty String string, @Nonnull ResolverStyle resolverStyle) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RegEx");
        ValueEnforcer.notNull((Object)((Object)resolverStyle), (String)"ResolverStyle");
        this.m_sPattern = string;
        this.m_eResolverStyle = resolverStyle;
        this.m_aFormatter = new DateTimeFormatterBuilder().appendPattern(string).toFormatter(Locale.getDefault(Locale.Category.FORMAT)).withResolverStyle(this.m_eResolverStyle);
    }

    @Nonnull
    @Nonempty
    public String getPattern() {
        return this.m_sPattern;
    }

    @Nonnull
    public ResolverStyle getResolverStyle() {
        return this.m_eResolverStyle;
    }

    @Nonnull
    public DateTimeFormatter getAsFormatter() {
        return this.m_aFormatter;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DateTimeFormatterPattern dateTimeFormatterPattern = (DateTimeFormatterPattern)object;
        return this.m_sPattern.equals(dateTimeFormatterPattern.m_sPattern) && this.m_eResolverStyle.equals((Object)dateTimeFormatterPattern.m_eResolverStyle);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_sPattern).append((Object)this.m_eResolverStyle).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Pattern", (Object)this.m_sPattern).append("ResolverStyle", (Enum)this.m_eResolverStyle).getToString();
    }
}

