/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.config.source.IConfigurationSource;
import com.helger.config.value.ConfiguredValue;
import com.helger.config.value.IConfigurationValueProvider;
import com.helger.config.value.IConfigurationValueProviderWithPriorityCallback;
import com.helger.io.resource.FileSystemResource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiConfigurationValueProvider
implements IConfigurationValueProvider,
ICloneable<MultiConfigurationValueProvider> {
    public static final boolean DEFAULT_USE_ONLY_INTIIALIZED_CONFIG_SOURCES = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiConfigurationValueProvider.class);
    private final ICommonsList<ConfigValueProviderWithPrio> m_aSources = new CommonsArrayList();
    private boolean m_bUseOnlyInitializedConfigSources = true;

    public MultiConfigurationValueProvider() {
    }

    public MultiConfigurationValueProvider(@Nullable List<? extends IConfigurationSource> list) {
        if (list != null) {
            for (IConfigurationSource iConfigurationSource : list) {
                this.addConfigurationSource(iConfigurationSource);
            }
        }
    }

    public MultiConfigurationValueProvider(IConfigurationSource ... iConfigurationSourceArray) {
        if (iConfigurationSourceArray != null) {
            for (IConfigurationSource iConfigurationSource : iConfigurationSourceArray) {
                this.addConfigurationSource(iConfigurationSource);
            }
        }
    }

    public final boolean isUseOnlyInitializedConfigSources() {
        return this.m_bUseOnlyInitializedConfigSources;
    }

    @Nonnull
    public final MultiConfigurationValueProvider setUseOnlyInitializedConfigSources(boolean bl) {
        this.m_bUseOnlyInitializedConfigSources = bl;
        return this;
    }

    @Nonnull
    public final MultiConfigurationValueProvider addConfigurationSource(@Nonnull IConfigurationSource iConfigurationSource) {
        ValueEnforcer.notNull((Object)iConfigurationSource, (String)"ConfigSource");
        if (this.m_bUseOnlyInitializedConfigSources && !iConfigurationSource.isInitializedAndUsable()) {
            LOGGER.warn("Not adding the configuration source " + String.valueOf(iConfigurationSource) + " because it is not yet initialized");
            return this;
        }
        return this.addConfigurationSource(iConfigurationSource, iConfigurationSource.getPriority());
    }

    @Nonnull
    public final MultiConfigurationValueProvider addConfigurationSource(@Nullable IConfigurationValueProvider iConfigurationValueProvider, int n) {
        if (iConfigurationValueProvider != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding configuration source " + String.valueOf(iConfigurationValueProvider) + " with priority " + n);
            }
            this.m_aSources.add((Object)new ConfigValueProviderWithPrio(iConfigurationValueProvider, n));
            this.m_aSources.sort((configValueProviderWithPrio, configValueProviderWithPrio2) -> configValueProviderWithPrio2.m_nPriority - configValueProviderWithPrio.m_nPriority);
        }
        return this;
    }

    @Nonnegative
    public final int getConfigurationSourceCount() {
        return this.m_aSources.size();
    }

    @Override
    @Nullable
    public ConfiguredValue getConfigurationValue(@Nonnull @Nonempty String string) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Trying to resolve configuration value of key '" + string + "' in " + this.m_aSources.size() + " sources");
        }
        ConfiguredValue configuredValue = null;
        for (ConfigValueProviderWithPrio configValueProviderWithPrio : this.m_aSources) {
            configuredValue = configValueProviderWithPrio.m_aCVP.getConfigurationValue(string);
            if (configuredValue == null) continue;
            break;
        }
        if (configuredValue != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Successfully resolved configuration value of key '" + string + "' to '" + configuredValue.getValue() + "' from " + String.valueOf((Object)configuredValue.getConfigurationSource().getSourceType()) + " with prio " + configuredValue.getConfigurationSource().getPriority());
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Failed to resolve configuration value of key '" + string + "'");
        }
        return configuredValue;
    }

    public void forEachConfigurationValueProvider(@Nonnull IConfigurationValueProviderWithPriorityCallback iConfigurationValueProviderWithPriorityCallback) {
        ValueEnforcer.notNull((Object)iConfigurationValueProviderWithPriorityCallback, (String)"aCallback");
        for (ConfigValueProviderWithPrio configValueProviderWithPrio : this.m_aSources) {
            iConfigurationValueProviderWithPriorityCallback.onConfigurationValueProvider(configValueProviderWithPrio.m_aCVP, configValueProviderWithPrio.m_nPriority);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public MultiConfigurationValueProvider getClone() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = new MultiConfigurationValueProvider();
        for (ConfigValueProviderWithPrio configValueProviderWithPrio : this.m_aSources) {
            IConfigurationValueProvider iConfigurationValueProvider = configValueProviderWithPrio.m_aCVP;
            if (iConfigurationValueProvider instanceof ICloneable) {
                ICloneable iCloneable = (ICloneable)iConfigurationValueProvider;
                iConfigurationValueProvider = (IConfigurationValueProvider)iCloneable.getClone();
                multiConfigurationValueProvider.m_aSources.add((Object)new ConfigValueProviderWithPrio(iConfigurationValueProvider, configValueProviderWithPrio.m_nPriority));
                continue;
            }
            multiConfigurationValueProvider.m_aSources.add((Object)configValueProviderWithPrio);
        }
        return multiConfigurationValueProvider;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Sources", this.m_aSources).append("UseOnlyInitializedConfigSources", this.m_bUseOnlyInitializedConfigSources).getToString();
    }

    @Nullable
    public static MultiConfigurationValueProvider createForClassPath(@Nonnull ClassLoader classLoader, @Nonnull String string, @Nonnull Function<URL, IConfigurationSource> function) {
        return MultiConfigurationValueProvider.createForAllOccurrances(classLoader, string, function, false);
    }

    @Nullable
    public static MultiConfigurationValueProvider createForAllOccurrances(@Nonnull ClassLoader classLoader, @Nonnull String string, @Nonnull Function<URL, IConfigurationSource> function, boolean bl) {
        IConfigurationSource iConfigurationSource;
        URL uRL;
        Enumeration enumeration;
        ValueEnforcer.notNull((Object)classLoader, (String)"ClassLoader");
        ValueEnforcer.notNull((Object)string, (String)"ClassPathElement");
        ValueEnforcer.notNull(function, (String)"Loader");
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        MultiConfigurationValueProvider multiConfigurationValueProvider = new MultiConfigurationValueProvider();
        try {
            enumeration = ClassLoaderHelper.getResources((ClassLoader)classLoader, (String)string);
            while (enumeration.hasMoreElements()) {
                uRL = (URL)enumeration.nextElement();
                if (!commonsHashSet.add((Object)uRL.toExternalForm())) {
                    LOGGER.warn("Ignoring duplicate configuration source URL '" + uRL.toExternalForm() + "'");
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Try to load configuration source from '" + uRL.toExternalForm() + "'");
                }
                if ((iConfigurationSource = function.apply(uRL)) == null) {
                    throw new IllegalStateException("Failed to load configration source '" + uRL.toExternalForm() + "'");
                }
                multiConfigurationValueProvider.addConfigurationSource(iConfigurationSource);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        if (bl && (enumeration = new FileSystemResource(string)).exists()) {
            uRL = enumeration.getAsURL();
            if (!commonsHashSet.add((Object)uRL.toExternalForm())) {
                LOGGER.warn("Ignoring duplicate configuration source URL '" + uRL.toExternalForm() + "'");
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Try to load configuration source from '" + uRL.toExternalForm() + "'");
                }
                if ((iConfigurationSource = function.apply(uRL)) == null) {
                    throw new IllegalStateException("Failed to load configration source '" + uRL.toExternalForm() + "'");
                }
                multiConfigurationValueProvider.addConfigurationSource(iConfigurationSource);
            }
        }
        if (multiConfigurationValueProvider.getConfigurationSourceCount() == 0) {
            return null;
        }
        return multiConfigurationValueProvider;
    }

    private static final class ConfigValueProviderWithPrio {
        private final IConfigurationValueProvider m_aCVP;
        private final int m_nPriority;

        public ConfigValueProviderWithPrio(@Nonnull IConfigurationValueProvider iConfigurationValueProvider, int n) {
            this.m_aCVP = iConfigurationValueProvider;
            this.m_nPriority = n;
        }

        public String toString() {
            return new ToStringGenerator(null).append("ConfigValProvider", (Object)this.m_aCVP).append("Priority", this.m_nPriority).getToString();
        }
    }
}

