/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.IConfigurationSource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

@MustImplementEqualsAndHashcode
@Immutable
public abstract class AbstractConfigurationSource
implements IConfigurationSource {
    private final EConfigSourceType m_eSourceType;
    private final int m_nPriority;

    protected static final boolean hasTrailingWhitespace(@Nullable String string) {
        return StringHelper.isNotEmpty((String)string) && Character.isWhitespace(string.charAt(string.length() - 1));
    }

    protected AbstractConfigurationSource(@Nonnull EConfigSourceType eConfigSourceType, int n) {
        ValueEnforcer.notNull((Object)((Object)eConfigSourceType), (String)"Type");
        this.m_eSourceType = eConfigSourceType;
        this.m_nPriority = n;
    }

    @Override
    @Nonnull
    public final EConfigSourceType getSourceType() {
        return this.m_eSourceType;
    }

    @Override
    public final int getPriority() {
        return this.m_nPriority;
    }

    public static boolean isSecretKey(@Nonnull String string) {
        String string2 = string.toLowerCase(Locale.ROOT);
        return string2.contains("password") || string2.contains("passwd");
    }

    @Nonnull
    protected static <V> String mapToStringIgnoreSecrets(@Nullable Map<String, V> map) {
        if (map == null) {
            return "null";
        }
        Iterator<Map.Entry<String, V>> iterator = map.entrySet().iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        while (true) {
            Map.Entry<String, V> entry = iterator.next();
            String string = entry.getKey();
            stringBuilder.append(string).append('=');
            if (AbstractConfigurationSource.isSecretKey(string)) {
                stringBuilder.append("****");
            } else {
                stringBuilder.append(entry.getValue());
            }
            if (!iterator.hasNext()) break;
            stringBuilder.append(',').append(' ');
        }
        return stringBuilder.append('}').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractConfigurationSource abstractConfigurationSource = (AbstractConfigurationSource)object;
        return this.m_eSourceType.equals((Object)abstractConfigurationSource.m_eSourceType) && this.m_nPriority == abstractConfigurationSource.m_nPriority;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_eSourceType).append(this.m_nPriority).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SourceType", (Enum)this.m_eSourceType).append("Priority", this.m_nPriority).getToString();
    }
}

