/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.base.string.StringHelper;
import com.helger.config.Config;
import com.helger.config.IConfig;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.IConfigurationSource;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.source.envvar.ConfigurationSourceEnvVar;
import com.helger.config.source.resource.AbstractConfigurationSourceResource;
import com.helger.config.source.resource.properties.ConfigurationSourceProperties;
import com.helger.config.source.resource.type.ConfigurationSourceResourceTypeRegistry;
import com.helger.config.source.sysprop.ConfigurationSourceSystemProperty;
import com.helger.io.file.FilenameHelper;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import com.helger.io.resourceprovider.ClassPathResourceProvider;
import com.helger.io.resourceprovider.FileSystemResourceProvider;
import com.helger.io.resourceprovider.IReadableResourceProvider;
import com.helger.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.io.url.URLHelper;
import jakarta.annotation.Nonnull;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ConfigFactory {
    public static final String PRIVATE_APPLICATION_PROPERTIES_NAME = "private-application.properties";
    public static final int PRIVATE_APPLICATION_PROPERTIES_PRIORITY = EConfigSourceType.RESOURCE.getDefaultPriority() - 10;
    public static final String APPLICATION_PROPERTIES_NAME = "application.properties";
    public static final int APPLICATION_PROPERTIES_PRIORITY = EConfigSourceType.RESOURCE.getDefaultPriority() - 20;
    public static final String REFERENCE_PROPERTIES_NAME = "reference.properties";
    public static final int REFERENCE_PROPERTIES_PRIORITY = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFactory.class);
    private static final String FALLBACK_SOURCE_TYPE = "properties";
    private static final IConfig SYSTEM_ONLY = Config.create(ConfigFactory.createValueProviderSystemOnly());
    private static final IConfig DEFAULT_INSTANCE = Config.create(ConfigFactory.createDefaultValueProvider());

    @Nonnull
    public static MultiConfigurationValueProvider createValueProviderSystemOnly() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = new MultiConfigurationValueProvider();
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceSystemProperty());
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceEnvVar());
        return multiConfigurationValueProvider;
    }

    @Nonnull
    public static ReadableResourceProviderChain createDefaultResourceProviderChain() {
        return new ReadableResourceProviderChain(new IReadableResourceProvider[]{new FileSystemResourceProvider().setCanReadRelativePaths(true), new ClassPathResourceProvider()});
    }

    @Nonnull
    public static MultiConfigurationValueProvider createDefaultValueProvider() {
        int n;
        Object object;
        Function<IReadableResource, AbstractConfigurationSourceResource> function;
        MultiConfigurationValueProvider multiConfigurationValueProvider = new MultiConfigurationValueProvider();
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceSystemProperty());
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceEnvVar());
        int n2 = EConfigSourceType.RESOURCE.getDefaultPriority();
        ClassLoader classLoader = ClassLoaderHelper.getDefaultClassLoader();
        String string = SYSTEM_ONLY.getAsString("config.resource");
        if (StringHelper.isNotEmpty((String)string)) {
            function = ConfigurationSourceResourceTypeRegistry.getInstance().getFactoryOfFileExtensionOrFallback(FilenameHelper.getExtension((String)string), FALLBACK_SOURCE_TYPE);
            object = new ClassPathResource(string);
            if (object.exists()) {
                n = SYSTEM_ONLY.getAsInt("config.resource.priority", n2);
                multiConfigurationValueProvider.addConfigurationSource(function.apply((IReadableResource)object), n);
            }
        }
        if (StringHelper.isNotEmpty((String)(string = SYSTEM_ONLY.getAsString("config.resources")))) {
            int n3 = SYSTEM_ONLY.getAsInt("config.resources.priority", n2);
            object = ConfigurationSourceResourceTypeRegistry.getInstance().getFactoryOfFileExtensionOrFallback(FilenameHelper.getExtension((String)string), FALLBACK_SOURCE_TYPE);
            multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForClassPath(classLoader, string, arg_0 -> ConfigFactory.lambda$createDefaultValueProvider$0((Function)object, arg_0)), n3);
        }
        if (StringHelper.isNotEmpty((String)(string = SYSTEM_ONLY.getAsString("config.file")))) {
            function = ConfigurationSourceResourceTypeRegistry.getInstance().getFactoryOfFileExtensionOrFallback(FilenameHelper.getExtension((String)string), FALLBACK_SOURCE_TYPE);
            object = new FileSystemResource(string);
            if (object.exists()) {
                n = SYSTEM_ONLY.getAsInt("config.file.priority", n2);
                multiConfigurationValueProvider.addConfigurationSource(function.apply((IReadableResource)object), n);
            }
        }
        if (StringHelper.isNotEmpty((String)(string = SYSTEM_ONLY.getAsString("config.url")))) {
            URLResource uRLResource;
            function = ConfigurationSourceResourceTypeRegistry.getInstance().getFactoryOfFileExtensionOrFallback(FilenameHelper.getExtension((String)string), FALLBACK_SOURCE_TYPE);
            object = URLHelper.getAsURL((String)string);
            if (object != null && (uRLResource = new URLResource((URL)object)).exists()) {
                int n4 = SYSTEM_ONLY.getAsInt("config.url.priority", n2);
                multiConfigurationValueProvider.addConfigurationSource(function.apply((IReadableResource)uRLResource), n4);
            }
        }
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForAllOccurrances(classLoader, PRIVATE_APPLICATION_PROPERTIES_NAME, uRL -> new ConfigurationSourceProperties(PRIVATE_APPLICATION_PROPERTIES_PRIORITY, (IReadableResource)new URLResource(uRL), StandardCharsets.UTF_8), true), PRIVATE_APPLICATION_PROPERTIES_PRIORITY);
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForAllOccurrances(classLoader, APPLICATION_PROPERTIES_NAME, uRL -> new ConfigurationSourceProperties(APPLICATION_PROPERTIES_PRIORITY, (IReadableResource)new URLResource(uRL), StandardCharsets.UTF_8), true), APPLICATION_PROPERTIES_PRIORITY);
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForAllOccurrances(classLoader, REFERENCE_PROPERTIES_NAME, uRL -> new ConfigurationSourceProperties(1, (IReadableResource)new URLResource(uRL), StandardCharsets.UTF_8), true), 1);
        return multiConfigurationValueProvider;
    }

    private ConfigFactory() {
    }

    @Nonnull
    public static IConfig getSystemConfig() {
        return SYSTEM_ONLY;
    }

    @Nonnull
    public static IConfig getDefaultConfig() {
        return DEFAULT_INSTANCE;
    }

    private static /* synthetic */ IConfigurationSource lambda$createDefaultValueProvider$0(Function function, URL uRL) {
        return (IConfigurationSource)function.apply(new URLResource(uRL));
    }

    static {
        int n = DEFAULT_INSTANCE.getResourceBasedConfigurationValueProviderCount();
        if (n == 0) {
            LOGGER.info("The default Config instance is solely based on system properties and environment variables. No configuration resources were found.");
        }
    }
}

