/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.gfx;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.dimension.SizeInt;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.collection.map.LRUMap;
import com.helger.io.resource.IReadableResource;
import com.helger.statistics.api.IMutableStatisticsHandlerCache;
import com.helger.statistics.impl.StatisticsManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ImageDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageDataManager.class);
    private static final IMutableStatisticsHandlerCache STATS_COUNTER = StatisticsManager.getCacheHandler(ImageDataManager.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<IReadableResource, SizeInt> m_aImageData;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<IReadableResource> m_aNonExistingResources = new CommonsHashSet();

    private ImageDataManager(@Nonnegative int n) {
        this.m_aImageData = new LRUMap(n);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull ImageDataManager getInstance() {
        ImageDataManager imageDataManager = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return imageDataManager;
    }

    private static @Nullable SizeInt _readImageData(@NonNull IHasInputStream iHasInputStream) {
        SizeInt sizeInt = null;
        try (InputStream inputStream = iHasInputStream.getInputStream();){
            if (inputStream != null) {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                if (bufferedImage != null) {
                    sizeInt = new SizeInt(bufferedImage.getWidth(), bufferedImage.getHeight());
                } else {
                    LOGGER.warn("Does not seem to be an image resource: " + String.valueOf(iHasInputStream));
                }
            } else {
                LOGGER.warn("Failed to resolve image resource: " + String.valueOf(iHasInputStream));
            }
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError linkageError) {
            LOGGER.error("Seems like no AWT binding is present", (Throwable)linkageError);
        }
        catch (IIOException iIOException) {
            LOGGER.error("Failed to interprete image data from resource " + String.valueOf(iHasInputStream) + ": " + iIOException.getMessage());
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to read image data from resource " + String.valueOf(iHasInputStream), (Throwable)iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error("Failed to read image data from resource " + String.valueOf(iHasInputStream) + ": " + illegalArgumentException.getMessage());
        }
        return sizeInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable SizeInt getImageSize(@Nullable IReadableResource iReadableResource) {
        SizeInt sizeInt;
        if (iReadableResource == null) {
            return null;
        }
        this.m_aRWLock.readLock().lock();
        try {
            sizeInt = (SizeInt)this.m_aImageData.get((Object)iReadableResource);
            if (sizeInt != null) {
                STATS_COUNTER.cacheHit();
                SizeInt sizeInt2 = sizeInt;
                return sizeInt2;
            }
            if (this.m_aNonExistingResources.contains((Object)iReadableResource)) {
                STATS_COUNTER.cacheHit();
                SizeInt sizeInt3 = null;
                return sizeInt3;
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        sizeInt = ImageDataManager._readImageData((IHasInputStream)iReadableResource);
        this.m_aRWLock.writeLocked(() -> {
            if (sizeInt == null) {
                this.m_aNonExistingResources.add((Object)iReadableResource);
            } else {
                this.m_aImageData.put((Object)iReadableResource, (Object)sizeInt);
            }
            STATS_COUNTER.cacheMiss();
        });
        return sizeInt;
    }

    public @NonNull EChange clearCachedSize(@Nullable IReadableResource iReadableResource) {
        if (iReadableResource == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aImageData.remove((Object)iReadableResource) != null) {
                return EChange.CHANGED;
            }
            if (this.m_aNonExistingResources.remove((Object)iReadableResource)) {
                return EChange.CHANGED;
            }
            return EChange.UNCHANGED;
        });
    }

    public @NonNull EChange clearCache() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aImageData.isEmpty() && this.m_aNonExistingResources.isEmpty()) {
                return EChange.UNCHANGED;
            }
            this.m_aImageData.clear();
            this.m_aNonExistingResources.clear();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cache was cleared: " + ImageDataManager.class.getName());
            }
            return EChange.CHANGED;
        });
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsMap<IReadableResource, SizeInt> getAllCachedSizes() {
        return (ICommonsMap)this.m_aRWLock.readLockedGet(() -> this.m_aImageData.getClone());
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<IReadableResource> getAllNotExistingResources() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aNonExistingResources.getClone());
    }

    private static final class SingletonHolder {
        private static final ImageDataManager INSTANCE = new ImageDataManager(1000);

        private SingletonHolder() {
        }
    }
}

