/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.homoglyphs;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@Immutable
public class HomoglyphSearchResult {
    private final int m_nIndex;
    private final String m_sMatch;
    private final String m_sWord;

    public HomoglyphSearchResult(@Nonnegative int n, @Nonempty @NonNull String string, @Nonempty @NonNull String string2) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Match");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Word");
        this.m_nIndex = n;
        this.m_sMatch = string;
        this.m_sWord = string2;
    }

    @Nonnegative
    public int getIndex() {
        return this.m_nIndex;
    }

    @Nonempty
    public @NonNull String getMatch() {
        return this.m_sMatch;
    }

    @Nonempty
    public @NonNull String getWord() {
        return this.m_sWord;
    }

    public @NonNull String getAsString() {
        return "'" + this.m_sMatch + "' at position " + this.m_nIndex + " matches '" + this.m_sWord + "'";
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Index", this.m_nIndex).append("Match", (Object)this.m_sMatch).append("Word", (Object)this.m_sWord).getToString();
    }
}

