/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.deadlock;

import com.helger.base.rt.StackTraceHelper;
import com.helger.commons.deadlock.IThreadDeadlockCallback;
import com.helger.commons.deadlock.ThreadDeadlockInfo;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingThreadDeadlockCallback
implements IThreadDeadlockCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingThreadDeadlockCallback.class);

    @Override
    public void onDeadlockDetected(@NonNull ThreadDeadlockInfo[] threadDeadlockInfoArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(threadDeadlockInfoArray.length).append(" deadlocked threads:\n");
        for (ThreadDeadlockInfo threadDeadlockInfo : threadDeadlockInfoArray) {
            Thread thread = threadDeadlockInfo.getThread();
            stringBuilder.append('\n').append(thread.toString()).append(":\n").append(StackTraceHelper.getStackAsString((Thread)thread));
        }
        LOGGER.error(stringBuilder.toString());
    }
}

