/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.jmx;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.string.StringReplace;
import jakarta.annotation.Nonnull;
import java.util.Hashtable;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;

@ThreadSafe
public final class ObjectNameHelper {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static String s_sDefaultJMXDomain = "com.helger";
    private static final ObjectNameHelper INSTANCE = new ObjectNameHelper();

    private ObjectNameHelper() {
    }

    public static void setDefaultJMXDomain(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DefaultJMXDomain");
        ValueEnforcer.isFalse((string.indexOf(58) >= 0 || string.indexOf(32) >= 0 ? 1 : 0) != 0, () -> "defaultJMXDomain contains invalid chars: " + string);
        RW_LOCK.writeLocked(() -> {
            s_sDefaultJMXDomain = string;
        });
    }

    @Nonnull
    @Nonempty
    public static String getDefaultJMXDomain() {
        return (String)RW_LOCK.readLockedGet(() -> s_sDefaultJMXDomain);
    }

    @Nonnull
    public static ObjectName create(@Nonnull @Nonempty Hashtable<String, String> hashtable) {
        ValueEnforcer.notEmpty(hashtable, (String)"Params");
        try {
            return new ObjectName(ObjectNameHelper.getDefaultJMXDomain(), hashtable);
        }
        catch (JMException jMException) {
            throw new IllegalArgumentException("Failed to create ObjectName with parameter " + String.valueOf(hashtable), jMException);
        }
    }

    @Nonnull
    public static ObjectName create(@Nonnull @Nonempty Map<String, String> map) {
        ValueEnforcer.notEmpty(map, (String)"Params");
        return ObjectNameHelper.create(new Hashtable<String, String>(map));
    }

    @Nonnull
    public static String getCleanPropertyValue(@Nonnull String string) {
        if (string.indexOf(32) != -1) {
            return ObjectName.quote(string);
        }
        String string2 = string;
        string2 = StringReplace.replaceAll((String)string2, (char)':', (char)'.');
        string2 = StringReplace.replaceAll((String)string2, (char)',', (char)'.');
        string2 = StringReplace.replaceAll((String)string2, (String)"//", (CharSequence)"__");
        return string2;
    }

    @Nonnull
    public static ObjectName createWithDefaultProperties(@Nonnull Object object) {
        ValueEnforcer.notNull((Object)object, (String)"Object");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", ClassHelper.getClassLocalName((Object)object));
        return ObjectNameHelper.create(hashtable);
    }

    @Nonnull
    public static ObjectName createWithDefaultProperties(@Nonnull Object object, @Nonnull String string) {
        ValueEnforcer.notNull((Object)object, (String)"Object");
        ValueEnforcer.notNull((Object)string, (String)"Name");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", ClassHelper.getClassLocalName((Object)object));
        hashtable.put("name", ObjectNameHelper.getCleanPropertyValue(string));
        return ObjectNameHelper.create(hashtable);
    }
}

