/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.serialize.convert;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.reflection.GenericReflection;
import com.helger.commons.serialize.convert.ISerializationConverter;
import com.helger.commons.serialize.convert.SerializationConverterRegistry;
import com.helger.typeconvert.TypeConverterException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@ThreadSafe
public final class SerializationConverter {
    private static final SerializationConverter INSTANCE = new SerializationConverter();

    private SerializationConverter() {
    }

    public static <T> void writeConvertedObject(@Nullable T t, @Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        ValueEnforcer.notNull((Object)objectOutputStream, (String)"ObjectOutputStream");
        objectOutputStream.writeBoolean(t == null);
        if (t != null) {
            Class clazz = (Class)GenericReflection.uncheckedCast(t.getClass());
            ISerializationConverter<T> iSerializationConverter = SerializationConverterRegistry.getInstance().getConverter(clazz);
            if (iSerializationConverter == null) {
                throw new TypeConverterException(clazz, TypeConverterException.EReason.NO_CONVERTER_FOUND_SINGLE);
            }
            iSerializationConverter.writeConvertedObject(t, objectOutputStream);
        }
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE readConvertedObject(@Nonnull ObjectInputStream objectInputStream, @Nonnull Class<DSTTYPE> clazz) throws IOException {
        ValueEnforcer.notNull((Object)objectInputStream, (String)"ObjectInputStream");
        ValueEnforcer.notNull(clazz, (String)"DestinationClass");
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            return null;
        }
        ISerializationConverter<DSTTYPE> iSerializationConverter = SerializationConverterRegistry.getInstance().getConverter(clazz);
        if (iSerializationConverter == null) {
            throw new TypeConverterException(clazz, TypeConverterException.EReason.NO_CONVERTER_FOUND_SINGLE);
        }
        return (DSTTYPE)GenericReflection.uncheckedCast(iSerializationConverter.readConvertedObject(objectInputStream));
    }
}

