/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.jmx;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.commons.jmx.ObjectNameHelper;
import jakarta.annotation.Nonnull;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JMXHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMXHelper.class);
    private static final JMXHelper INSTANCE = new JMXHelper();

    private JMXHelper() {
    }

    @Nonnull
    public static ESuccess exposeMBean(@Nonnull Object object, @Nonnull ObjectName objectName) {
        ValueEnforcer.notNull((Object)object, (String)"Object");
        ValueEnforcer.notNull((Object)objectName, (String)"ObjectName");
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(object, objectName);
            return ESuccess.SUCCESS;
        }
        catch (JMException jMException) {
            LOGGER.error("Error registering MBean with name " + String.valueOf(objectName), (Throwable)jMException);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static ESuccess exposeMBeanWithAutoName(@Nonnull Object object) {
        return JMXHelper.exposeMBean(object, ObjectNameHelper.createWithDefaultProperties(object));
    }

    @Nonnull
    public static ESuccess exposeMBeanWithAutoName(@Nonnull Object object, @Nonnull String string) {
        return JMXHelper.exposeMBean(object, ObjectNameHelper.createWithDefaultProperties(object, string));
    }
}

