/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.homoglyphs;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.set.IntSet;
import com.helger.commons.homoglyphs.Homoglyph;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

@Immutable
public final class HomoglyphBuilder {
    public static final String CHAR_CODES_FILE = "homoglyph/char_codes.txt";

    private HomoglyphBuilder() {
    }

    @Nonnull
    public static Homoglyph build() throws IOException {
        return HomoglyphBuilder.build((IReadableResource)new ClassPathResource(CHAR_CODES_FILE));
    }

    @Nonnull
    public static Homoglyph build(@Nonnull IReadableResource iReadableResource) throws IOException {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        return HomoglyphBuilder.build(iReadableResource.getReader(StandardCharsets.ISO_8859_1));
    }

    @Nonnull
    public static Homoglyph build(@Nonnull @WillClose Reader reader) throws IOException {
        ValueEnforcer.notNull((Object)reader, (String)"reader");
        try (NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader(reader);){
            Homoglyph homoglyph;
            String string;
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                homoglyph = new IntSet(string.length() / 3);
                for (String string2 : StringHelper.getExploded((char)',', (String)string)) {
                    int n = StringParser.parseInt((String)string2, (int)16, (int)-1);
                    if (n < 0) continue;
                    homoglyph.add(n);
                }
                commonsArrayList.add((Object)homoglyph);
            }
            homoglyph = new Homoglyph((ICommonsList<IntSet>)commonsArrayList);
            return homoglyph;
        }
    }
}

