/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resourceprovider;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ReadableResourceProviderChain
implements IReadableResourceProvider {
    private final ICommonsList<IReadableResourceProvider> m_aReadingResourceProviders;

    public ReadableResourceProviderChain(IReadableResourceProvider ... iReadableResourceProviderArray) {
        ValueEnforcer.notEmptyNoNullValue(iReadableResourceProviderArray, "ResourceProviders");
        this.m_aReadingResourceProviders = new CommonsArrayList<IReadableResourceProvider>(iReadableResourceProviderArray);
    }

    public ReadableResourceProviderChain(@Nonnull Iterable<? extends IReadableResourceProvider> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, "ResourceProviders");
        this.m_aReadingResourceProviders = new CommonsArrayList<Iterable<? extends IReadableResourceProvider>>(iterable);
    }

    @Nonnull
    @ReturnsMutableObject
    protected final ICommonsList<IReadableResourceProvider> readingResourceProviders() {
        return this.m_aReadingResourceProviders;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IReadableResourceProvider> getAllContainedReadingResourceProviders() {
        return (ICommonsList)this.m_aReadingResourceProviders.getClone();
    }

    @Override
    public final boolean supportsReading(@Nullable String string) {
        return this.m_aReadingResourceProviders.containsAny(iReadableResourceProvider -> iReadableResourceProvider.supportsReading(string));
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public IReadableResource getReadableResource(@Nonnull String string) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            if (!iReadableResourceProvider.supportsReading(string)) continue;
            return iReadableResourceProvider.getReadableResource(string);
        }
        throw new IllegalArgumentException("Cannot handle reading '" + string + "' by any of " + String.valueOf(this.m_aReadingResourceProviders));
    }

    @Nullable
    public IReadableResource getReadableResourceIf(@Nonnull String string, @Nonnull Predicate<? super IReadableResource> predicate) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            IReadableResource iReadableResource;
            if (!iReadableResourceProvider.supportsReading(string) || !predicate.test(iReadableResource = iReadableResourceProvider.getReadableResource(string))) continue;
            return iReadableResource;
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream getInputStream(@Nonnull String string) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            InputStream inputStream = iReadableResourceProvider.getInputStream(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadableResourceProviderChain readableResourceProviderChain = (ReadableResourceProviderChain)object;
        return this.m_aReadingResourceProviders.equals(readableResourceProviderChain.m_aReadingResourceProviders);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aReadingResourceProviders)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("readableResProviders", this.m_aReadingResourceProviders).getToString();
    }
}

