/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.callback.exception;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.level.IHasErrorLevel;
import com.helger.commons.exception.mock.IMockException;
import com.helger.commons.log.LogHelper;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LoggingExceptionCallback
implements IExceptionCallback<Throwable>,
IHasErrorLevel {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingExceptionCallback.class);
    private IErrorLevel m_aErrorLevel = EErrorLevel.ERROR;

    @Override
    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Nonnull
    public final LoggingExceptionCallback setErrorLevel(@Nonnull IErrorLevel iErrorLevel) {
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        return this;
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getLogMessage(@Nullable Throwable throwable) {
        if (throwable == null) {
            return "An error occurred";
        }
        return "An exception was thrown";
    }

    @OverrideOnDemand
    protected boolean isLogException(@Nullable Throwable throwable) {
        return !(throwable instanceof IMockException);
    }

    @Override
    public void onException(@Nullable Throwable throwable) {
        String string = this.getLogMessage(throwable);
        boolean bl = this.isLogException(throwable);
        LogHelper.log(LOGGER, this.m_aErrorLevel, string, bl ? throwable : null);
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

