/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.stack;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.EmptyStackException;

@NotThreadSafe
public class NonBlockingStack<ELEMENTTYPE>
extends CommonsArrayList<ELEMENTTYPE> {
    public NonBlockingStack() {
    }

    public NonBlockingStack(@Nonnegative int n) {
        super(n);
    }

    @SafeVarargs
    public NonBlockingStack(ELEMENTTYPE ... ELEMENTTYPEArray) {
        this.addAll(ELEMENTTYPEArray);
    }

    public NonBlockingStack(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public NonBlockingStack(@Nullable NonBlockingStack<? extends ELEMENTTYPE> nonBlockingStack) {
        if (nonBlockingStack != null) {
            this.addAll(nonBlockingStack);
        }
    }

    @Nullable
    public ELEMENTTYPE push(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.add(ELEMENTTYPE);
        return ELEMENTTYPE;
    }

    @Nullable
    public ELEMENTTYPE pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.removeLastOrNull();
    }

    @Nullable
    public ELEMENTTYPE peek() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.getLastOrNull();
    }

    @Nullable
    public ELEMENTTYPE top() {
        return this.peek();
    }

    @Nullable
    public ELEMENTTYPE firstElement() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.getFirstOrNull();
    }

    @Nullable
    public ELEMENTTYPE replaceTopElement(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        this.setLast(ELEMENTTYPE);
        return ELEMENTTYPE;
    }

    @Override
    @Nonnull
    public NonBlockingStack<ELEMENTTYPE> getClone() {
        return new NonBlockingStack<ELEMENTTYPE>(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(super.hashCode()).getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator((Object)this).append("list", (Object)super.toString()).getToString();
    }
}

