/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.hierarchy;

import com.helger.annotation.Nonnegative;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.hierarchy.IHasChildren;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;
import java.util.function.Predicate;

public interface IHasChildrenSorted<CHILDTYPE>
extends IHasChildren<CHILDTYPE> {
    @Override
    @Nullable
    public ICommonsList<? extends CHILDTYPE> getAllChildren();

    @Nullable
    public CHILDTYPE getChildAtIndex(@Nonnegative int var1);

    @Nullable
    default public CHILDTYPE getFirstChild() {
        return this.getChildAtIndex(0);
    }

    @Nullable
    default public CHILDTYPE findFirstChild(@Nonnull Predicate<? super CHILDTYPE> predicate) {
        if (this.hasNoChildren()) {
            return null;
        }
        return this.getChildren().findFirst(predicate);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE findFirstChildMapped(@Nonnull Predicate<? super CHILDTYPE> predicate, @Nonnull Function<? super CHILDTYPE, ? extends DSTTYPE> function) {
        if (this.hasNoChildren()) {
            return null;
        }
        return this.getChildren().findFirstMapped(predicate, function);
    }

    @Nullable
    default public CHILDTYPE getLastChild() {
        return this.getChildAtIndex(this.getChildCount() - 1);
    }
}

