/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cli.IOptionBase;
import com.helger.cli.Option;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.typeconvert.trait.IGetterByKeyTrait;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class ParsedCmdLine
implements IGetterByKeyTrait<String> {
    private final ICommonsOrderedMap<IOptionBase, ICommonsList<String>> m_aParams = new CommonsLinkedHashMap();
    private final ICommonsList<String> m_aUnknownTokens = new CommonsArrayList();

    void internalAddValue(@NonNull IOptionBase iOptionBase2, @NonNull ICommonsList<String> iCommonsList) {
        ValueEnforcer.notNull((Object)iOptionBase2, (String)"Option");
        ValueEnforcer.notNull(iCommonsList, (String)"Values");
        ((ICommonsList)this.m_aParams.computeIfAbsent((Object)iOptionBase2, iOptionBase -> new CommonsArrayList())).addAll(iCommonsList);
    }

    void internalAddUnhandledToken(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"UnknownToken");
        this.m_aUnknownTokens.add((Object)string);
    }

    private @Nullable ICommonsList<String> _find(@Nullable IOptionBase iOptionBase) {
        return iOptionBase == null ? null : (ICommonsList)this.m_aParams.get((Object)iOptionBase);
    }

    private @Nullable ICommonsList<String> _find(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        for (Map.Entry entry : this.m_aParams.entrySet()) {
            Option option;
            Object k = entry.getKey();
            if (!(k instanceof Option) || !(option = (Option)k).matches(string)) continue;
            return (ICommonsList)entry.getValue();
        }
        return null;
    }

    public boolean hasOption(@Nullable IOptionBase iOptionBase) {
        return this._find(iOptionBase) != null;
    }

    public boolean hasOption(@Nullable String string) {
        return this._find(string) != null;
    }

    public @Nullable String getValue(@NonNull IOptionBase iOptionBase) {
        ICommonsList<String> iCommonsList = this._find(iOptionBase);
        return iCommonsList == null ? null : (String)iCommonsList.getFirstOrNull();
    }

    public @Nullable String getValue(@Nullable String string) {
        ICommonsList<String> iCommonsList = this._find(string);
        return iCommonsList == null ? null : (String)iCommonsList.getFirstOrNull();
    }

    @ReturnsMutableObject
    public @Nullable ICommonsList<String> values(@NonNull IOptionBase iOptionBase) {
        ICommonsList<String> iCommonsList = this._find(iOptionBase);
        return iCommonsList == null ? null : (ICommonsList)iCommonsList.getClone();
    }

    @ReturnsMutableObject
    public @Nullable ICommonsList<String> values(@NonNull String string) {
        ICommonsList<String> iCommonsList = this._find(string);
        return iCommonsList == null ? null : (ICommonsList)iCommonsList.getClone();
    }

    @ReturnsMutableObject
    public @NonNull ICommonsList<String> unknownTokens() {
        return this.m_aUnknownTokens;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Params", this.m_aParams).append("UnknownTokens", this.m_aUnknownTokens).getToString();
    }
}

