/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.cli.Option;
import com.helger.cli.OptionValidator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class OptionBuilder
implements IBuilder<Option> {
    final String m_sShortOpt;
    String m_sLongOpt;
    String m_sDescription;
    int m_nMinArgs = 0;
    int m_nMaxArgs = 0;
    String m_sArgName;
    Option.EOptionMultiplicity m_eMultiplicity = Option.EOptionMultiplicity.OPTIONAL_ONCE;
    char m_cValueSep = '\u0000';

    protected OptionBuilder(@Nullable String string) {
        if (string != null) {
            OptionValidator.validateShortOption(string);
        }
        this.m_sShortOpt = string;
    }

    public @NonNull OptionBuilder longOpt(@Nullable String string) {
        this.m_sLongOpt = string;
        return this;
    }

    public @NonNull OptionBuilder desc(@Nullable String string) {
        this.m_sDescription = string;
        return this;
    }

    public @NonNull OptionBuilder minArgs(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"MinArgs");
        this.m_nMinArgs = n;
        return this;
    }

    public @NonNull OptionBuilder maxArgs(int n) {
        ValueEnforcer.isTrue((n == -1 || n >= 0 ? 1 : 0) != 0, () -> "MaxArgs must be -1 or >= 0!");
        this.m_nMaxArgs = n;
        return this;
    }

    public @NonNull OptionBuilder maxArgsInfinite() {
        return this.maxArgs(-1);
    }

    public @NonNull OptionBuilder args(@Nonnegative int n, int n2) {
        return this.minArgs(n).maxArgs(n2);
    }

    public @NonNull OptionBuilder args(@Nonnegative int n) {
        return this.minArgs(n).maxArgs(n);
    }

    public @NonNull OptionBuilder argName(@Nullable String string) {
        this.m_sArgName = string;
        return this;
    }

    public @NonNull OptionBuilder required(boolean bl) {
        this.m_eMultiplicity = bl ? this.m_eMultiplicity.getAsRequired() : this.m_eMultiplicity.getAsOptional();
        return this;
    }

    public @NonNull OptionBuilder repeatable(boolean bl) {
        this.m_eMultiplicity = bl ? this.m_eMultiplicity.getAsRepeatable() : this.m_eMultiplicity.getAsOnce();
        return this;
    }

    public @NonNull OptionBuilder valueSeparator(char c) {
        this.m_cValueSep = c;
        return this;
    }

    @ReturnsMutableCopy
    public @NonNull Option build() {
        if (StringHelper.isEmpty((String)this.m_sShortOpt) && StringHelper.isEmpty((String)this.m_sLongOpt)) {
            throw new IllegalStateException("Either opt or longOpt must be specified");
        }
        if (this.m_nMaxArgs != -1 && this.m_nMaxArgs < this.m_nMinArgs) {
            throw new IllegalStateException("MinArgs (" + this.m_nMinArgs + ") must be <= MaxArgs (" + this.m_nMaxArgs + ")");
        }
        if (this.m_nMinArgs == 0 && this.m_nMaxArgs == 0) {
            if (this.m_sArgName != null) {
                throw new IllegalStateException("ArgName may only be provided if at least one argument is present");
            }
            if (this.m_eMultiplicity.isRequired()) {
                Option.LOGGER.warn("Having a required option without an argument may not be what is desired.");
            }
            if (this.m_eMultiplicity.isRepeatable()) {
                Option.LOGGER.warn("Having a repeatable option without an argument may not be what is desired.");
            }
            if (this.m_cValueSep != '\u0000') {
                throw new IllegalStateException("ValueSeparator may only be provided if at least one argument is present");
            }
        }
        return new Option(this);
    }
}

