/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.cli.IOptionBase;
import com.helger.cli.Option;
import com.helger.cli.OptionBuilder;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import jakarta.annotation.Nonnull;

@NotThreadSafe
public class OptionGroup
extends CommonsArrayList<Option>
implements IOptionBase {
    private boolean m_bRequired = false;

    @Nonnull
    public OptionGroup addOption(@Nonnull OptionBuilder optionBuilder) {
        return this.addOption(optionBuilder.build());
    }

    @Nonnull
    public OptionGroup addOption(@Nonnull Option option) {
        ValueEnforcer.notNull((Object)option, (String)"Option");
        super.add((Object)option);
        return this;
    }

    @Override
    public final boolean isRequired() {
        return this.m_bRequired;
    }

    @Nonnull
    public final OptionGroup setRequired(boolean bl) {
        this.m_bRequired = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Option> getAllOptions() {
        return this.getClone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

