/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cli.IOptionBase;
import com.helger.cli.Option;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.typeconvert.trait.IGetterByKeyTrait;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@NotThreadSafe
public class ParsedCmdLine
implements IGetterByKeyTrait<String> {
    private final ICommonsOrderedMap<IOptionBase, ICommonsList<String>> m_aParams = new CommonsLinkedHashMap();
    private final ICommonsList<String> m_aUnknownTokens = new CommonsArrayList();

    void internalAddValue(@Nonnull IOptionBase iOptionBase2, @Nonnull ICommonsList<String> iCommonsList) {
        ValueEnforcer.notNull((Object)iOptionBase2, (String)"Option");
        ValueEnforcer.notNull(iCommonsList, (String)"Values");
        ((ICommonsList)this.m_aParams.computeIfAbsent((Object)iOptionBase2, iOptionBase -> new CommonsArrayList())).addAll(iCommonsList);
    }

    void internalAddUnhandledToken(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"UnknownToken");
        this.m_aUnknownTokens.add((Object)string);
    }

    @Nullable
    private ICommonsList<String> _find(@Nullable IOptionBase iOptionBase) {
        return iOptionBase == null ? null : (ICommonsList)this.m_aParams.get((Object)iOptionBase);
    }

    @Nullable
    private ICommonsList<String> _find(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        for (Map.Entry entry : this.m_aParams.entrySet()) {
            Option option;
            Object k = entry.getKey();
            if (!(k instanceof Option) || !(option = (Option)k).matches(string)) continue;
            return (ICommonsList)entry.getValue();
        }
        return null;
    }

    public boolean hasOption(@Nullable IOptionBase iOptionBase) {
        return this._find(iOptionBase) != null;
    }

    public boolean hasOption(@Nullable String string) {
        return this._find(string) != null;
    }

    @Nullable
    public String getValue(@Nonnull IOptionBase iOptionBase) {
        ICommonsList<String> iCommonsList = this._find(iOptionBase);
        return iCommonsList == null ? null : (String)iCommonsList.getFirstOrNull();
    }

    @Nullable
    public String getValue(@Nullable String string) {
        ICommonsList<String> iCommonsList = this._find(string);
        return iCommonsList == null ? null : (String)iCommonsList.getFirstOrNull();
    }

    @Nullable
    @ReturnsMutableObject
    public ICommonsList<String> values(@Nonnull IOptionBase iOptionBase) {
        ICommonsList<String> iCommonsList = this._find(iOptionBase);
        return iCommonsList == null ? null : (ICommonsList)iCommonsList.getClone();
    }

    @Nullable
    @ReturnsMutableObject
    public ICommonsList<String> values(@Nonnull String string) {
        ICommonsList<String> iCommonsList = this._find(string);
        return iCommonsList == null ? null : (ICommonsList)iCommonsList.getClone();
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<String> unknownTokens() {
        return this.m_aUnknownTokens;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Params", this.m_aParams).append("UnknownTokens", this.m_aUnknownTokens).getToString();
    }
}

