/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import com.helger.cli.Option;
import com.helger.cli.OptionGroup;
import com.helger.cli.Options;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.compare.IComparator;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.ENewLineMode;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_LONG_OPT_SEPARATOR = " ";
    public static final String DEFAULT_ARG_NAME = "arg";
    private int m_nDefaultWidth = 74;
    private int m_nDefaultLeftPad = 1;
    private int m_nDefaultDescPad = 3;
    private String m_sDefaultSyntaxPrefix = "usage: ";
    private String m_sDefaultNewLine = ENewLineMode.DEFAULT.getText();
    private String m_sOptPrefix = "-";
    private String m_sLongOptPrefix = "--";
    private String m_sArgName = "arg";
    private IComparator<Option> m_aOptionComparator = (IComparator & Serializable)(option, option2) -> option.getKey().compareToIgnoreCase(option2.getKey());
    private String m_sLongOptSeparator = " ";

    public void setWidth(int n) {
        this.m_nDefaultWidth = n;
    }

    public int getWidth() {
        return this.m_nDefaultWidth;
    }

    public void setLeftPadding(int n) {
        this.m_nDefaultLeftPad = n;
    }

    public int getLeftPadding() {
        return this.m_nDefaultLeftPad;
    }

    public void setDescPadding(int n) {
        this.m_nDefaultDescPad = n;
    }

    public int getDescPadding() {
        return this.m_nDefaultDescPad;
    }

    public void setSyntaxPrefix(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Prefix");
        this.m_sDefaultSyntaxPrefix = string;
    }

    @Nonnull
    public String getSyntaxPrefix() {
        return this.m_sDefaultSyntaxPrefix;
    }

    public void setNewLine(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"NewLine");
        this.m_sDefaultNewLine = string;
    }

    @Nonnull
    public String getNewLine() {
        return this.m_sDefaultNewLine;
    }

    public void setOptPrefix(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Prefix");
        this.m_sOptPrefix = string;
    }

    @Nonnull
    public String getOptPrefix() {
        return this.m_sOptPrefix;
    }

    public void setLongOptPrefix(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Prefix");
        this.m_sLongOptPrefix = string;
    }

    @Nonnull
    public String getLongOptPrefix() {
        return this.m_sLongOptPrefix;
    }

    public void setLongOptSeparator(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"LongOptSeparator");
        this.m_sLongOptSeparator = string;
    }

    @Nonnull
    public String getLongOptSeparator() {
        return this.m_sLongOptSeparator;
    }

    public void setArgName(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        this.m_sArgName = string;
    }

    @Nonnull
    public String getArgName() {
        return this.m_sArgName;
    }

    @Nullable
    public IComparator<Option> getOptionComparator() {
        return this.m_aOptionComparator;
    }

    public void setOptionComparator(@Nullable IComparator<Option> iComparator) {
        this.m_aOptionComparator = iComparator;
    }

    public void printHelp(@Nonnull @Nonempty String string, @Nonnull Options options) {
        this.printHelp(this.getWidth(), string, null, options, null, false);
    }

    public void printHelp(@Nonnull @Nonempty String string, @Nonnull Options options, boolean bl) {
        this.printHelp(this.getWidth(), string, null, options, null, bl);
    }

    public void printHelp(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Options options, @Nullable String string3) {
        this.printHelp(string, string2, options, string3, false);
    }

    public void printHelp(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Options options, @Nullable String string3, boolean bl) {
        this.printHelp(this.getWidth(), string, string2, options, string3, bl);
    }

    public void printHelp(int n, @Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Options options, @Nullable String string3) {
        this.printHelp(n, string, string2, options, string3, false);
    }

    public void printHelp(int n, @Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Options options, @Nullable String string3, boolean bl) {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.printHelp(printWriter, n, string, string2, options, this.getLeftPadding(), this.getDescPadding(), string3, bl);
        printWriter.flush();
    }

    public void printHelp(@Nonnull PrintWriter printWriter, int n, @Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Options options, int n2, int n3, @Nullable String string3) {
        this.printHelp(printWriter, n, string, string2, options, n2, n3, string3, false);
    }

    public void printHelp(@Nonnull PrintWriter printWriter, int n, @Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Options options, int n2, int n3, @Nullable String string3, boolean bl) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"sCmdLineSyntax");
        if (bl) {
            this.printUsage(printWriter, n, string, options);
        } else {
            this.printUsage(printWriter, n, string);
        }
        if (string2 != null && string2.trim().length() > 0) {
            this.printWrapped(printWriter, n, string2);
        }
        this.printOptions(printWriter, n, options, n2, n3);
        if (string3 != null && string3.trim().length() > 0) {
            this.printWrapped(printWriter, n, string3);
        }
    }

    public void printUsage(@Nonnull PrintWriter printWriter, int n, String string, Options options) {
        StringBuilder stringBuilder = new StringBuilder(this.getSyntaxPrefix()).append(string).append(' ');
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        ICommonsList<Option> iCommonsList = options.getAllResolvedOptions();
        if (this.m_aOptionComparator != null) {
            iCommonsList.sort(this.m_aOptionComparator);
        }
        Iterator iterator = iCommonsList.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            OptionGroup optionGroup = options.getOptionGroup(option);
            if (optionGroup != null) {
                if (commonsHashSet.add((Object)optionGroup)) {
                    this._appendOptionGroup(stringBuilder, optionGroup);
                }
            } else {
                this._appendOption(stringBuilder, option, option.isRequired());
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(' ');
        }
        this.printWrapped(printWriter, n, stringBuilder.toString().indexOf(32) + 1, stringBuilder.toString());
    }

    private void _appendOptionGroup(StringBuilder stringBuilder, OptionGroup optionGroup) {
        if (!optionGroup.isRequired()) {
            stringBuilder.append('[');
        }
        ICommonsList<Option> iCommonsList = optionGroup.getAllOptions();
        if (this.m_aOptionComparator != null) {
            iCommonsList.sort(this.m_aOptionComparator);
        }
        Iterator iterator = iCommonsList.iterator();
        while (iterator.hasNext()) {
            this._appendOption(stringBuilder, (Option)iterator.next(), true);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" | ");
        }
        if (!optionGroup.isRequired()) {
            stringBuilder.append(']');
        }
    }

    private void _appendOption(@Nonnull StringBuilder stringBuilder, @Nonnull Option option, boolean bl) {
        if (!bl) {
            stringBuilder.append('[');
        }
        if (option.hasShortOpt()) {
            stringBuilder.append(this.getOptPrefix()).append(option.getShortOpt());
        } else {
            stringBuilder.append(this.getLongOptPrefix()).append(option.getLongOpt());
        }
        if (option.canHaveArgs()) {
            stringBuilder.append(option.hasShortOpt() ? DEFAULT_LONG_OPT_SEPARATOR : this.getLongOptSeparator());
            stringBuilder.append('<').append(option.hasArgName() ? option.getArgName() : this.getArgName()).append('>');
        }
        if (!bl) {
            stringBuilder.append(']');
        }
    }

    public void printUsage(@Nonnull PrintWriter printWriter, int n, String string) {
        int n2 = string.indexOf(32) + 1;
        this.printWrapped(printWriter, n, this.getSyntaxPrefix().length() + n2, this.getSyntaxPrefix() + string);
    }

    public void printOptions(@Nonnull PrintWriter printWriter, int n, @Nonnull Options options, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        this.renderOptions(stringBuilder, n, options, n2, n3);
        printWriter.println(stringBuilder.toString());
    }

    public void printWrapped(@Nonnull PrintWriter printWriter, int n, @Nonnull String string) {
        this.printWrapped(printWriter, n, 0, string);
    }

    public void printWrapped(@Nonnull PrintWriter printWriter, int n, int n2, @Nonnull String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        this._renderWrappedTextBlock(stringBuilder, n, n2, string);
        printWriter.println(stringBuilder.toString());
    }

    protected StringBuilder renderOptions(@Nonnull StringBuilder stringBuilder, int n, @Nonnull Options options, int n2, int n3) {
        CharSequence charSequence;
        Object object;
        Object object22;
        String string = HelpFormatter.createPadding(n2);
        String string2 = HelpFormatter.createPadding(n3);
        int n4 = 0;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ICommonsList<Option> iCommonsList = options.getAllOptions();
        if (this.m_aOptionComparator != null) {
            iCommonsList.sort(this.m_aOptionComparator);
        }
        for (Object object22 : iCommonsList) {
            object = new StringBuilder();
            if (((Option)object22).hasShortOpt()) {
                ((StringBuilder)object).append(string).append(this.getOptPrefix()).append(((Option)object22).getShortOpt());
                if (((Option)object22).hasLongOpt()) {
                    ((StringBuilder)object).append(',').append(this.getLongOptPrefix()).append(((Option)object22).getLongOpt());
                }
            } else {
                ((StringBuilder)object).append(string).append("   ").append(this.getLongOptPrefix()).append(((Option)object22).getLongOpt());
            }
            if (((Option)object22).canHaveArgs()) {
                charSequence = ((Option)object22).getArgName();
                if (charSequence != null && ((String)charSequence).length() == 0) {
                    ((StringBuilder)object).append(' ');
                } else {
                    ((StringBuilder)object).append(((Option)object22).hasLongOpt() ? this.getLongOptSeparator() : DEFAULT_LONG_OPT_SEPARATOR);
                    ((StringBuilder)object).append('<').append(charSequence != null ? ((Option)object22).getArgName() : this.getArgName()).append('>');
                }
            }
            commonsArrayList.add(object);
            n4 = Math.max(((StringBuilder)object).length(), n4);
        }
        int n5 = 0;
        object22 = iCommonsList.iterator();
        while (object22.hasNext()) {
            object = (Option)object22.next();
            if (((StringBuilder)(charSequence = new StringBuilder(((StringBuilder)commonsArrayList.get(n5++)).toString()))).length() < n4) {
                ((StringBuilder)charSequence).append(HelpFormatter.createPadding(n4 - ((StringBuilder)charSequence).length()));
            }
            ((StringBuilder)charSequence).append(string2);
            int n6 = n4 + n3;
            if (((Option)object).hasDescription()) {
                ((StringBuilder)charSequence).append(((Option)object).getDescription());
            }
            this.renderWrappedText(stringBuilder, n, n6, ((StringBuilder)charSequence).toString());
            if (!object22.hasNext()) continue;
            stringBuilder.append(this.getNewLine());
        }
        return stringBuilder;
    }

    protected StringBuilder renderWrappedText(StringBuilder stringBuilder, int n, int n2, String string) {
        Object object = string;
        int n3 = HelpFormatter.findWrapPos((String)object, n, 0);
        if (n3 == -1) {
            stringBuilder.append(HelpFormatter.rtrim((String)object));
            return stringBuilder;
        }
        stringBuilder.append(HelpFormatter.rtrim(((String)object).substring(0, n3))).append(this.getNewLine());
        int n4 = n2;
        if (n4 >= n) {
            n4 = 1;
        }
        String string2 = HelpFormatter.createPadding(n4);
        while (true) {
            if ((n3 = HelpFormatter.findWrapPos((String)(object = string2 + ((String)object).substring(n3).trim()), n, 0)) == -1) {
                stringBuilder.append((String)object);
                return stringBuilder;
            }
            if (((String)object).length() > n && n3 == n4 - 1) {
                n3 = n;
            }
            stringBuilder.append(HelpFormatter.rtrim(((String)object).substring(0, n3))).append(this.getNewLine());
        }
    }

    @Nonnull
    private StringBuilder _renderWrappedTextBlock(StringBuilder stringBuilder, int n, int n2, String string) {
        try (NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader((Reader)new NonBlockingStringReader(string));){
            String string2;
            boolean bl = true;
            while ((string2 = nonBlockingBufferedReader.readLine()) != null) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(this.getNewLine());
                }
                this.renderWrappedText(stringBuilder, n, n2, string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder;
    }

    @CheckForSigned
    protected static int findWrapPos(String string, int n, int n2) {
        char c;
        int n3 = string.indexOf(10, n2);
        if (n3 != -1 && n3 <= n) {
            return n3 + 1;
        }
        n3 = string.indexOf(9, n2);
        if (n3 != -1 && n3 <= n) {
            return n3 + 1;
        }
        if (n2 + n >= string.length()) {
            return -1;
        }
        for (n3 = n2 + n; n3 >= n2 && (c = string.charAt(n3)) != ' ' && c != '\n' && c != '\r'; --n3) {
        }
        if (n3 > n2) {
            return n3;
        }
        n3 = n2 + n;
        return n3 == string.length() ? -1 : n3;
    }

    @Nonnull
    protected static String createPadding(@Nonnegative int n) {
        return StringHelper.getRepeated((char)' ', (int)n);
    }

    @Nullable
    protected static String rtrim(@Nullable String string) {
        int n;
        if (StringHelper.hasNoText((String)string)) {
            return string;
        }
        for (n = string.length(); n > 0 && Character.isWhitespace(string.charAt(n - 1)); --n) {
        }
        return string.substring(0, n);
    }
}

