/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import com.helger.cli.IOptionBase;
import com.helger.cli.OptionValidator;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class Option
implements IOptionBase {
    public static final char DEFAULT_VALUE_SEPARATOR = '\u0000';
    public static final int INFINITE_VALUES = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(Option.class);
    private final String m_sShortOpt;
    private final String m_sLongOpt;
    private final String m_sDescription;
    private final int m_nMinArgs;
    private final int m_nMaxArgs;
    private final String m_sArgName;
    private final EOptionMultiplicity m_eMultiplicity;
    private final char m_cValueSep;

    protected Option(@Nonnull Builder builder) {
        ValueEnforcer.notNull((Object)builder, (String)"Builder");
        this.m_sShortOpt = builder.m_sShortOpt;
        this.m_sLongOpt = builder.m_sLongOpt;
        this.m_sDescription = builder.m_sDescription;
        this.m_nMinArgs = builder.m_nMinArgs;
        this.m_nMaxArgs = builder.m_nMaxArgs;
        this.m_sArgName = builder.m_sArgName;
        this.m_eMultiplicity = builder.m_eMultiplicity;
        this.m_cValueSep = builder.m_cValueSep;
    }

    @Nonnull
    @Nonempty
    public final String getKey() {
        return this.hasShortOpt() ? this.m_sShortOpt : this.m_sLongOpt;
    }

    @Nullable
    public String getShortOpt() {
        return this.m_sShortOpt;
    }

    public boolean hasShortOpt() {
        return StringHelper.hasText((String)this.m_sShortOpt);
    }

    public boolean hasShortOpt(@Nullable String string) {
        return string != null && string.equals(this.m_sShortOpt);
    }

    @Nullable
    public String getLongOpt() {
        return this.m_sLongOpt;
    }

    public boolean hasLongOpt() {
        return this.m_sLongOpt != null;
    }

    public boolean hasLongOpt(@Nullable String string) {
        return string != null && string.equals(this.m_sLongOpt);
    }

    public boolean matches(@Nullable String string) {
        return string != null && (string.equals(this.m_sShortOpt) || string.equals(this.m_sLongOpt));
    }

    @Nullable
    public String getDescription() {
        return this.m_sDescription;
    }

    public boolean hasDescription() {
        return StringHelper.hasText((String)this.m_sDescription);
    }

    @Nonnegative
    public int getMinArgCount() {
        return this.m_nMinArgs;
    }

    public boolean hasMinArgs() {
        return this.m_nMinArgs != 0;
    }

    @Nonnegative
    public int getMaxArgCount() {
        return this.m_nMaxArgs;
    }

    public boolean hasInfiniteArgs() {
        return this.m_nMaxArgs == -1;
    }

    public boolean canHaveMoreValues(int n) {
        return this.hasInfiniteArgs() || n < this.m_nMaxArgs;
    }

    public boolean canHaveArgs() {
        return this.hasInfiniteArgs() || this.m_nMaxArgs > 0;
    }

    @Nullable
    public String getArgName() {
        return this.m_sArgName;
    }

    public boolean isRepeatable() {
        return this.m_eMultiplicity.isRepeatable();
    }

    @Override
    public boolean isRequired() {
        return this.m_eMultiplicity.isRequired();
    }

    public boolean hasArgName() {
        return StringHelper.hasText((String)this.m_sArgName);
    }

    public char getValueSeparator() {
        return this.m_cValueSep;
    }

    public boolean hasValueSeparator() {
        return this.m_cValueSep != '\u0000';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Option option = (Option)object;
        return EqualsHelper.equals((Object)this.m_sShortOpt, (Object)option.m_sShortOpt) && EqualsHelper.equals((Object)this.m_sLongOpt, (Object)option.m_sLongOpt);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sShortOpt).append((Object)this.m_sLongOpt).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("Opt", (Object)this.m_sShortOpt).appendIfNotNull("LongOpt", (Object)this.m_sLongOpt).appendIfNotNull("Description", (Object)this.m_sDescription).appendIf("MinArgs", this.m_nMinArgs, this::hasMinArgs).appendIf("MaxArgs", (Object)(this.m_nMaxArgs == -1 ? "infinite" : Integer.toString(this.m_nMaxArgs)), this::canHaveArgs).appendIfNotNull("ArgName", (Object)this.m_sArgName).append("Multiplicity", (Enum)this.m_eMultiplicity).appendIf("ValueSep", this.m_cValueSep, this::hasValueSeparator).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder(null);
    }

    @Nonnull
    public static Builder builder(@Nullable String string) {
        return new Builder(string);
    }

    public static class Builder
    implements IBuilder<Option> {
        private final String m_sShortOpt;
        private String m_sLongOpt;
        private String m_sDescription;
        private int m_nMinArgs = 0;
        private int m_nMaxArgs = 0;
        private String m_sArgName;
        private EOptionMultiplicity m_eMultiplicity = EOptionMultiplicity.OPTIONAL_ONCE;
        private char m_cValueSep = '\u0000';

        protected Builder(@Nullable String string) {
            if (string != null) {
                OptionValidator.validateShortOption(string);
            }
            this.m_sShortOpt = string;
        }

        @Nonnull
        public Builder longOpt(@Nullable String string) {
            this.m_sLongOpt = string;
            return this;
        }

        @Nonnull
        public Builder desc(@Nullable String string) {
            this.m_sDescription = string;
            return this;
        }

        @Nonnull
        public Builder minArgs(@Nonnegative int n) {
            ValueEnforcer.isGE0((int)n, (String)"MinArgs");
            this.m_nMinArgs = n;
            return this;
        }

        @Nonnull
        public Builder maxArgs(int n) {
            ValueEnforcer.isTrue((n == -1 || n >= 0 ? 1 : 0) != 0, () -> "MaxArgs must be -1 or >= 0!");
            this.m_nMaxArgs = n;
            return this;
        }

        @Nonnull
        public Builder maxArgsInfinite() {
            return this.maxArgs(-1);
        }

        @Nonnull
        public Builder args(@Nonnegative int n, int n2) {
            return this.minArgs(n).maxArgs(n2);
        }

        @Nonnull
        public Builder args(@Nonnegative int n) {
            return this.minArgs(n).maxArgs(n);
        }

        @Nonnull
        public Builder argName(@Nullable String string) {
            this.m_sArgName = string;
            return this;
        }

        @Nonnull
        public Builder required(boolean bl) {
            this.m_eMultiplicity = bl ? this.m_eMultiplicity.getAsRequired() : this.m_eMultiplicity.getAsOptional();
            return this;
        }

        @Nonnull
        public Builder repeatable(boolean bl) {
            this.m_eMultiplicity = bl ? this.m_eMultiplicity.getAsRepeatable() : this.m_eMultiplicity.getAsOnce();
            return this;
        }

        @Nonnull
        public Builder valueSeparator(char c) {
            this.m_cValueSep = c;
            return this;
        }

        @Nonnull
        @ReturnsMutableCopy
        public Option build() {
            if (StringHelper.hasNoText((String)this.m_sShortOpt) && StringHelper.hasNoText((String)this.m_sLongOpt)) {
                throw new IllegalStateException("Either opt or longOpt must be specified");
            }
            if (this.m_nMaxArgs != -1 && this.m_nMaxArgs < this.m_nMinArgs) {
                throw new IllegalStateException("MinArgs (" + this.m_nMinArgs + ") must be <= MaxArgs (" + this.m_nMaxArgs + ")");
            }
            if (this.m_nMinArgs == 0 && this.m_nMaxArgs == 0) {
                if (this.m_sArgName != null) {
                    throw new IllegalStateException("ArgName may only be provided if at least one argument is present");
                }
                if (this.m_eMultiplicity.isRequired()) {
                    LOGGER.warn("Having a required option without an argument may not be what is desired.");
                }
                if (this.m_eMultiplicity.isRepeatable()) {
                    LOGGER.warn("Having a repeatable option without an argument may not be what is desired.");
                }
                if (this.m_cValueSep != '\u0000') {
                    throw new IllegalStateException("ValueSeparator may only be provided if at least one argument is present");
                }
            }
            return new Option(this);
        }
    }

    public static enum EOptionMultiplicity {
        OPTIONAL_ONCE,
        OPTIONAL_MANY,
        REQUIRED_ONCE,
        REQUIRED_MANY;


        public boolean isOptional() {
            return this == OPTIONAL_ONCE || this == OPTIONAL_MANY;
        }

        public boolean isRequired() {
            return this == REQUIRED_ONCE || this == REQUIRED_MANY;
        }

        public boolean isOnce() {
            return this == OPTIONAL_ONCE || this == REQUIRED_ONCE;
        }

        public boolean isRepeatable() {
            return this == OPTIONAL_MANY || this == REQUIRED_MANY;
        }

        @Nonnull
        public EOptionMultiplicity getAsRequired() {
            if (this == OPTIONAL_ONCE) {
                return REQUIRED_ONCE;
            }
            if (this == OPTIONAL_MANY) {
                return REQUIRED_MANY;
            }
            return this;
        }

        @Nonnull
        public EOptionMultiplicity getAsOptional() {
            if (this == REQUIRED_ONCE) {
                return OPTIONAL_ONCE;
            }
            if (this == REQUIRED_MANY) {
                return OPTIONAL_MANY;
            }
            return this;
        }

        @Nonnull
        public EOptionMultiplicity getAsRepeatable() {
            if (this == OPTIONAL_ONCE) {
                return OPTIONAL_MANY;
            }
            if (this == REQUIRED_ONCE) {
                return REQUIRED_MANY;
            }
            return this;
        }

        @Nonnull
        public EOptionMultiplicity getAsOnce() {
            if (this == OPTIONAL_MANY) {
                return OPTIONAL_ONCE;
            }
            if (this == REQUIRED_MANY) {
                return REQUIRED_ONCE;
            }
            return this;
        }
    }
}

