/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cache.regex;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.RegEx;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.CGlobal;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.cache.regex.RegExCache;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class RegExHelper {
    private static final RegExHelper INSTANCE = new RegExHelper();

    private RegExHelper() {
    }

    public static @NonNull String[] getSplitToArray(@Nullable CharSequence charSequence, @RegEx @NonNull String string) {
        if (charSequence == null) {
            return CGlobal.EMPTY_STRING_ARRAY;
        }
        return RegExCache.getPattern(string).split(charSequence);
    }

    public static @NonNull String[] getSplitToArray(@Nullable CharSequence charSequence, @RegEx @NonNull String string, @Nonnegative int n) {
        ValueEnforcer.notNull((Object)string, (String)"RegEx");
        if (charSequence == null) {
            return CGlobal.EMPTY_STRING_ARRAY;
        }
        return RegExCache.getPattern(string).split(charSequence, n);
    }

    public static @NonNull ICommonsList<String> getSplitToList(@Nullable CharSequence charSequence, @RegEx @NonNull String string) {
        return new CommonsArrayList((Object[])RegExHelper.getSplitToArray(charSequence, string));
    }

    public static @NonNull ICommonsList<String> getSplitToList(@Nullable CharSequence charSequence, @RegEx @NonNull String string, @Nonnegative int n) {
        return new CommonsArrayList((Object[])RegExHelper.getSplitToArray(charSequence, string, n));
    }

    public static @NonNull Matcher getMatcher(@RegEx @NonNull String string, @NonNull String string2) {
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        return RegExCache.getPattern(string).matcher(string2);
    }

    public static @NonNull Matcher getMatcher(@RegEx @NonNull String string, @Nonnegative int n, @NonNull String string2) {
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        return RegExCache.getPattern(string, n).matcher(string2);
    }

    public static boolean stringMatchesPattern(@RegEx @NonNull String string, @NonNull String string2) {
        return RegExHelper.getMatcher(string, string2).matches();
    }

    public static boolean stringMatchesPattern(@RegEx @NonNull String string, @Nonnegative int n, @NonNull String string2) {
        return RegExHelper.getMatcher(string, n, string2).matches();
    }

    public static @NonNull String stringReplacePattern(@RegEx @NonNull String string, @NonNull String string2, @Nullable String string3) {
        return RegExHelper.getMatcher(string, string2).replaceAll(StringHelper.getNotNull((String)string3));
    }

    public static @NonNull String stringReplacePattern(@RegEx @NonNull String string, @Nonnegative int n, @NonNull String string2, @Nullable String string3) {
        return RegExHelper.getMatcher(string, n, string2).replaceAll(StringHelper.getNotNull((String)string3));
    }

    public static @Nullable String getAsIdentifier(@Nullable String string) {
        return RegExHelper.getAsIdentifier(string, "_");
    }

    public static @Nullable String getAsIdentifier(@Nullable String string, char c) {
        if (StringHelper.isEmpty((String)string)) {
            return string;
        }
        Object object = c == '$' || c == '\\' ? "\\" + c : Character.toString(c);
        String string2 = RegExHelper.stringReplacePattern("\\W", string, (String)object);
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            return (String)object + string2;
        }
        return string2;
    }

    public static @Nullable String getAsIdentifier(@Nullable String string, @NonNull String string2) {
        ValueEnforcer.notNull((Object)string2, (String)"Replacement");
        if (StringHelper.isEmpty((String)string)) {
            return string;
        }
        String string3 = RegExHelper.stringReplacePattern("\\W", string, string2);
        if (string3.length() == 0) {
            return string2;
        }
        if (!Character.isJavaIdentifierStart(string3.charAt(0))) {
            return string2 + string3;
        }
        return string3;
    }

    public static boolean isValidPattern(@RegEx @NonNull String string) {
        try {
            Pattern.compile(string);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public static @Nullable String[] getAllMatchingGroupValues(@RegEx @NonNull String string, @NonNull String string2) {
        Matcher matcher = RegExHelper.getMatcher(string, string2);
        if (!matcher.find()) {
            return null;
        }
        int n = matcher.groupCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = matcher.group(i + 1);
        }
        return stringArray;
    }
}

