/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cache.regex;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.RegEx;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.cache.impl.Cache;
import com.helger.cache.regex.RegExPattern;
import jakarta.annotation.Nonnull;
import java.util.regex.Pattern;

@ThreadSafe
public final class RegExCache
extends Cache<RegExPattern, Pattern> {
    public static final int MAX_CACHE_SIZE = 1000;
    private static boolean s_bDefaultInstantiated = false;

    private RegExCache() {
        super(RegExPattern::getAsPattern, 1000, RegExCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static RegExCache getInstance() {
        RegExCache regExCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return regExCache;
    }

    @Nonnull
    public static Pattern getPattern(@Nonnull @RegEx @Nonempty String string) {
        return (Pattern)RegExCache.getInstance().getFromCache(new RegExPattern(string));
    }

    @Nonnull
    public static Pattern getPattern(@Nonnull @RegEx @Nonempty String string, @Nonnegative int n) {
        return (Pattern)RegExCache.getInstance().getFromCache(new RegExPattern(string, n));
    }

    private static final class SingletonHolder {
        private static final RegExCache INSTANCE = new RegExCache();

        private SingletonHolder() {
        }
    }
}

