/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.uuid;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class UUID5Helper {
    private UUID5Helper() {
    }

    private static @NonNull UUID _makeUUID5(byte @NonNull [] byArray) {
        ValueEnforcer.notNull(byArray, "HashBytes");
        ValueEnforcer.isEqual(byArray.length, 20, "Expected 20 bytes from SHA-1");
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x50);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0x80);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, 16);
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        return new UUID(l, l2);
    }

    public static @NonNull UUID fromBytes(byte @NonNull [] byArray) {
        ValueEnforcer.notNull(byArray, "Name");
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            return UUID5Helper._makeUUID5(messageDigest.digest(byArray));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    public static @NonNull UUID fromBytes(@Nullable UUID uUID, byte @NonNull [] byArray) {
        ValueEnforcer.notNull(byArray, "NameBytes");
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            if (uUID == null) {
                messageDigest.update(new byte[16]);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocate(16);
                byteBuffer.putLong(uUID.getMostSignificantBits());
                byteBuffer.putLong(uUID.getLeastSignificantBits());
                messageDigest.update(byteBuffer.array());
            }
            return UUID5Helper._makeUUID5(messageDigest.digest(byArray));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    public static @NonNull UUID fromUTF8(@NonNull String string) {
        return UUID5Helper.fromBytes(string.getBytes(StandardCharsets.UTF_8));
    }

    public static @NonNull UUID fromUTF8(@Nullable UUID uUID, @NonNull String string) {
        return UUID5Helper.fromBytes(uUID, string.getBytes(StandardCharsets.UTF_8));
    }
}

