/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.tostring;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.functional.IBooleanPredicate;
import com.helger.base.functional.ICharPredicate;
import com.helger.base.string.StringHex;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public final class ToStringGenerator {
    public static final String CONSTANT_NULL = "null";
    public static final String CONSTANT_THIS = "this";
    public static final String CONSTANT_PASSWORD = "****";
    private static final int FIRST_FIELD = 1;
    private static final int APPENDED_CLOSING_BRACKET = 2;
    private final StringBuilder m_aSB = new StringBuilder("[");
    private final Object m_aSrc;
    private int m_nIndex = 0;

    public ToStringGenerator(@Nullable Object object) {
        if (object != null) {
            String string = object.getClass().getName();
            int n = string.lastIndexOf(46);
            this.m_aSB.append(n == -1 ? string : string.substring(n + 1)).append("@0x").append(StringHex.getHexStringLeadingZero(System.identityHashCode(object), 8));
        }
        this.m_aSrc = object;
    }

    private void _beforeAddField() {
        if ((this.m_nIndex & 1) == 0) {
            this.m_nIndex |= 1;
            if (this.m_aSB.length() > 1) {
                this.m_aSB.append(": ");
            }
        } else {
            this.m_aSB.append("; ");
        }
    }

    private @NonNull ToStringGenerator _appendSuper(String string) {
        this._beforeAddField();
        this.m_aSB.append(string);
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, boolean bl) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(bl);
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, boolean @Nullable [] blArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(blArray));
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, byte by) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(by);
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, byte @Nullable [] byArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(byArray));
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, char c) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append('\'').append(c).append('\'');
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, char @Nullable [] cArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(cArray));
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, double d) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(d);
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, double @Nullable [] dArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(dArray));
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, float f) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(f);
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, float @Nullable [] fArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(fArray));
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, int n) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(n);
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, int @Nullable [] nArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(nArray));
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, long l) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(l);
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, long @Nullable [] lArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(lArray));
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, short s) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(s);
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, short @Nullable [] sArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(sArray));
        return this;
    }

    public @NonNull ToStringGenerator appendPassword(@NonNull String string) {
        return this.append(string, CONSTANT_PASSWORD);
    }

    public @NonNull ToStringGenerator append(@NonNull String string, @Nullable Enum<?> enum_) {
        return this.append(string, String.valueOf(enum_));
    }

    private @NonNull ToStringGenerator _appendArray(@NonNull String string, @NonNull Object object) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (clazz.equals(Byte.TYPE)) {
                return this.append(string, (byte[])object);
            }
            if (clazz.equals(Boolean.TYPE)) {
                return this.append(string, (boolean[])object);
            }
            if (clazz.equals(Character.TYPE)) {
                return this.append(string, (char[])object);
            }
            if (clazz.equals(Double.TYPE)) {
                return this.append(string, (double[])object);
            }
            if (clazz.equals(Float.TYPE)) {
                return this.append(string, (float[])object);
            }
            if (clazz.equals(Integer.TYPE)) {
                return this.append(string, (int[])object);
            }
            if (clazz.equals(Long.TYPE)) {
                return this.append(string, (long[])object);
            }
            if (clazz.equals(Short.TYPE)) {
                return this.append(string, (short[])object);
            }
        }
        return this.append(string, (Object[])object);
    }

    private @NonNull String _getObjectValue(@Nullable Object object) {
        if (object == null) {
            return CONSTANT_NULL;
        }
        return EqualsHelper.identityEqual(object, this.m_aSrc) ? CONSTANT_THIS : object.toString();
    }

    public @NonNull ToStringGenerator append(@NonNull String string, @Nullable Object object) {
        if (object != null && object.getClass().isArray()) {
            return this._appendArray(string, object);
        }
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(this._getObjectValue(object));
        return this;
    }

    public @NonNull ToStringGenerator append(@NonNull String string, @Nullable Object[] objectArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=');
        if (objectArray == null) {
            this.m_aSB.append(CONSTANT_NULL);
        } else {
            int n = objectArray.length - 1;
            if (n == -1) {
                this.m_aSB.append("[]");
            } else {
                this.m_aSB.append('[');
                int n2 = 0;
                while (true) {
                    this.m_aSB.append(this._getObjectValue(objectArray[n2]));
                    if (n2 == n) break;
                    this.m_aSB.append(", ");
                    ++n2;
                }
                this.m_aSB.append(']');
            }
        }
        return this;
    }

    public @NonNull ToStringGenerator appendIf(@NonNull String string, boolean bl, @NonNull IBooleanPredicate iBooleanPredicate) {
        return iBooleanPredicate.test(bl) ? this.append(string, bl) : this;
    }

    public @NonNull ToStringGenerator appendIf(@NonNull String string, boolean bl, @NonNull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, bl) : this;
    }

    public @NonNull ToStringGenerator appendIf(@NonNull String string, char c, @NonNull ICharPredicate iCharPredicate) {
        return iCharPredicate.test(c) ? this.append(string, c) : this;
    }

    public @NonNull ToStringGenerator appendIf(@NonNull String string, char c, @NonNull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, c) : this;
    }

    public @NonNull ToStringGenerator appendIf(@NonNull String string, int n, @NonNull IntPredicate intPredicate) {
        return intPredicate.test(n) ? this.append(string, n) : this;
    }

    public @NonNull ToStringGenerator appendIf(@NonNull String string, int n, @NonNull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, n) : this;
    }

    public @NonNull ToStringGenerator appendIf(@NonNull String string, long l, @NonNull LongPredicate longPredicate) {
        return longPredicate.test(l) ? this.append(string, l) : this;
    }

    public @NonNull ToStringGenerator appendIf(@NonNull String string, long l, @NonNull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, l) : this;
    }

    public @NonNull ToStringGenerator appendIf(@NonNull String string, double d, @NonNull DoublePredicate doublePredicate) {
        return doublePredicate.test(d) ? this.append(string, d) : this;
    }

    public @NonNull ToStringGenerator appendIf(@NonNull String string, double d, @NonNull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, d) : this;
    }

    public <T> @NonNull ToStringGenerator appendIf(@NonNull String string, @Nullable T t, @NonNull Predicate<? super T> predicate) {
        return predicate.test(t) ? this.append(string, t) : this;
    }

    public <T> @NonNull ToStringGenerator appendIf(@NonNull String string, @Nullable T t, @NonNull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, t) : this;
    }

    public @NonNull ToStringGenerator appendIfNotNull(@NonNull String string, @Nullable Object object) {
        return object == null ? this : this.append(string, object);
    }

    public @NonNull ToStringGenerator appendPasswordIf(@NonNull String string, BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.appendPassword(string) : this;
    }

    public @NonNull String getToString() {
        if ((this.m_nIndex & 2) == 0) {
            this.m_nIndex |= 2;
            this.m_aSB.append(']');
        }
        return this.m_aSB.toString();
    }

    @Deprecated(forRemoval=false)
    public @NonNull String toString() {
        return this.getToString();
    }

    public static @NonNull ToStringGenerator getDerived(@NonNull String string) {
        return new ToStringGenerator(null)._appendSuper(string);
    }
}

