/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.spi;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.annotation.style.IsSPIInterface;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.log.IHasConditionalLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ServiceLoaderHelper
implements IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoaderHelper.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER);

    private ServiceLoaderHelper() {
    }

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    @ReturnsMutableCopy
    public static <T> @NonNull List<T> getAllSPIImplementations(@NonNull Class<T> clazz) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, ClassLoaderHelper.getDefaultClassLoader(), null);
    }

    @ReturnsMutableCopy
    public static <T> @NonNull List<T> getAllSPIImplementations(@NonNull Class<T> clazz, @NonNull ClassLoader classLoader) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, classLoader, null);
    }

    @ReturnsMutableCopy
    public static <T> @NonNull List<T> getAllSPIImplementations(@NonNull Class<T> clazz, @Nullable Logger logger) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, ClassLoaderHelper.getDefaultClassLoader(), logger);
    }

    @ReturnsMutableCopy
    public static <T> @NonNull List<T> getAllSPIImplementations(@NonNull Class<T> clazz, @NonNull ClassLoader classLoader, @Nullable Logger logger) {
        Logger logger2;
        ValueEnforcer.notNull(clazz, "SPIClass");
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        Logger logger3 = logger2 = logger != null ? logger : LOGGER;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Trying to retrieve all SPI implementations of " + String.valueOf(clazz));
        }
        if (CONDLOG.isEnabled() && clazz.getAnnotation(IsSPIInterface.class) == null) {
            CONDLOG.warn(String.valueOf(clazz) + " should have the @IsSPIInterface annotation");
        }
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, classLoader);
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : serviceLoader) {
            try {
                if (CONDLOG.isEnabled() && t.getClass().getAnnotation(IsSPIImplementation.class) == null) {
                    LOGGER.warn(String.valueOf(t) + " should have the @IsSPIImplementation annotation");
                }
                arrayList.add(t);
            }
            catch (Exception exception) {
                logger2.error("Unable to load an SPI implementation of " + String.valueOf(clazz), (Throwable)exception);
            }
        }
        if (logger2.isDebugEnabled()) {
            logger2.debug("Finished retrieving all " + arrayList.size() + " SPI implementations of " + String.valueOf(clazz));
        }
        return arrayList;
    }

    public static <T> @Nullable T getFirstSPIImplementation(@NonNull Class<T> clazz) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, ClassLoaderHelper.getDefaultClassLoader(), null);
    }

    public static <T> @Nullable T getFirstSPIImplementation(@NonNull Class<T> clazz, @NonNull ClassLoader classLoader) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, classLoader, null);
    }

    public static <T> @Nullable T getFirstSPIImplementation(@NonNull Class<T> clazz, @Nullable Logger logger) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, ClassLoaderHelper.getDefaultClassLoader(), logger);
    }

    public static <T> @Nullable T getFirstSPIImplementation(@NonNull Class<T> clazz, @NonNull ClassLoader classLoader, @Nullable Logger logger) {
        Logger logger2 = logger != null ? logger : LOGGER;
        List<T> list = ServiceLoaderHelper.getAllSPIImplementations(clazz, classLoader, logger2);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            logger2.warn("Requested only one SPI implementation of " + String.valueOf(clazz) + " but found " + list.size() + " - using the first one. Details: " + String.valueOf(list));
        }
        return list.get(0);
    }
}

