/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.location;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.functional.Predicates;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.location.ILocation;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import javax.xml.stream.Location;
import javax.xml.transform.SourceLocator;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

@Immutable
public class SimpleLocation
implements ILocation {
    public static final SimpleLocation NO_LOCATION = new SimpleLocation(null);
    private final String m_sResourceID;
    private final int m_nColumnNumber;
    private final int m_nLineNumber;

    public SimpleLocation(@Nullable String string) {
        this(string, -1, -1);
    }

    public SimpleLocation(@Nullable String string, int n, int n2) {
        this.m_sResourceID = string;
        this.m_nLineNumber = n;
        this.m_nColumnNumber = n2;
    }

    @Override
    public @Nullable String getResourceID() {
        return this.m_sResourceID;
    }

    @Override
    public int getLineNumber() {
        return this.m_nLineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.m_nColumnNumber;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SimpleLocation simpleLocation = (SimpleLocation)object;
        return EqualsHelper.equals(this.m_sResourceID, simpleLocation.m_sResourceID) && this.m_nLineNumber == simpleLocation.m_nLineNumber && this.m_nColumnNumber == simpleLocation.m_nColumnNumber;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sResourceID).append(this.m_nLineNumber).append(this.m_nColumnNumber).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("ResourceID", this.m_sResourceID).appendIf("LineNumber", this.m_nLineNumber, Predicates.intIsGE0()).appendIf("ColumnNumber", this.m_nColumnNumber, Predicates.intIsGE0()).getToString();
    }

    public static @Nullable SimpleLocation create(@Nullable Locator locator) {
        if (locator == null) {
            return null;
        }
        return new SimpleLocation(StringHelper.getConcatenatedOnDemand(locator.getPublicId(), "/", locator.getSystemId()), locator.getLineNumber(), locator.getColumnNumber());
    }

    public static @Nullable SimpleLocation create(@Nullable SourceLocator sourceLocator) {
        if (sourceLocator == null) {
            return null;
        }
        return new SimpleLocation(StringHelper.getConcatenatedOnDemand(sourceLocator.getPublicId(), "/", sourceLocator.getSystemId()), sourceLocator.getLineNumber(), sourceLocator.getColumnNumber());
    }

    public static @Nullable SimpleLocation create(@Nullable SAXParseException sAXParseException) {
        if (sAXParseException == null) {
            return null;
        }
        return new SimpleLocation(StringHelper.getConcatenatedOnDemand(sAXParseException.getPublicId(), "/", sAXParseException.getSystemId()), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
    }

    public static @Nullable SimpleLocation create(@Nullable Location location) {
        if (location == null) {
            return null;
        }
        return new SimpleLocation(StringHelper.getConcatenatedOnDemand(location.getPublicId(), "/", location.getSystemId()), location.getLineNumber(), location.getColumnNumber());
    }
}

