/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.lang.clazz;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringReplace;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class ClassHelper {
    @CodingStyleguideUnaware
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new WeakHashMap(8);
    @CodingStyleguideUnaware
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE = new WeakHashMap(8);
    private static final ClassHelper INSTANCE;

    private static void _registerPrimitiveMapping(@NonNull Class<?> clazz, @NonNull Class<?> clazz2) {
        PRIMITIVE_TO_WRAPPER.put(clazz, clazz2);
        WRAPPER_TO_PRIMITIVE.put(clazz2, clazz);
    }

    protected ClassHelper() {
    }

    public static boolean isPublicClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isInterface() || clazz.isAnnotation()) {
            return false;
        }
        if (!ClassHelper.isPublic(clazz)) {
            return false;
        }
        return !ClassHelper.isAbstractClass(clazz);
    }

    public static boolean isInstancableClass(@Nullable Class<?> clazz) {
        if (!ClassHelper.isPublicClass(clazz)) {
            return false;
        }
        try {
            clazz.getConstructor(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return true;
    }

    public static boolean isPublic(@Nullable Class<?> clazz) {
        return clazz != null && Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isInterface(@Nullable Class<?> clazz) {
        return clazz != null && Modifier.isInterface(clazz.getModifiers());
    }

    public static boolean isAnnotationClass(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isAnnotation();
    }

    public static boolean isEnumClass(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isEnum();
    }

    public static boolean isAbstractClass(@Nullable Class<?> clazz) {
        return clazz != null && !clazz.isArray() && Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isArrayClass(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isArray();
    }

    public static boolean isPrimitiveType(@Nullable Class<?> clazz) {
        return clazz != null && PRIMITIVE_TO_WRAPPER.containsKey(clazz);
    }

    public static boolean isPrimitiveWrapperType(@Nullable Class<?> clazz) {
        return clazz != null && WRAPPER_TO_PRIMITIVE.containsKey(clazz);
    }

    public static @Nullable Class<?> getPrimitiveWrapperClass(@Nullable Class<?> clazz) {
        if (ClassHelper.isPrimitiveWrapperType(clazz)) {
            return clazz;
        }
        return PRIMITIVE_TO_WRAPPER.get(clazz);
    }

    public static @Nullable Class<?> getPrimitiveClass(@Nullable Class<?> clazz) {
        if (ClassHelper.isPrimitiveType(clazz)) {
            return clazz;
        }
        return WRAPPER_TO_PRIMITIVE.get(clazz);
    }

    @ReturnsMutableCopy
    public static @NonNull Set<Class<?>> getAllPrimitiveClasses() {
        return new HashSet(PRIMITIVE_TO_WRAPPER.keySet());
    }

    @ReturnsMutableCopy
    public static @NonNull Set<Class<?>> getAllPrimitiveWrapperClasses() {
        return new HashSet(WRAPPER_TO_PRIMITIVE.keySet());
    }

    public static boolean isStringClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return CharSequence.class.isAssignableFrom(clazz);
    }

    public static boolean isCharacterClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz);
    }

    public static boolean isBooleanClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz);
    }

    public static boolean isFloatingPointClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz);
    }

    public static boolean isIntegerClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz);
    }

    public static boolean areConvertibleClasses(@NonNull Class<?> clazz, @NonNull Class<?> clazz2) {
        ValueEnforcer.notNull(clazz, "SrcClass");
        ValueEnforcer.notNull(clazz2, "DstClass");
        if (clazz2.equals(clazz)) {
            return true;
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz2 == ClassHelper.getPrimitiveWrapperClass(clazz)) {
            return true;
        }
        return clazz2 == ClassHelper.getPrimitiveClass(clazz);
    }

    public static @Nullable Class<?> getClass(@Nullable Object object) {
        return object == null ? null : object.getClass();
    }

    public static @Nullable String getClassName(@Nullable Object object) {
        return object == null ? null : object.getClass().getName();
    }

    public static @Nullable String getClassLocalName(@Nullable Object object) {
        return object == null ? null : ClassHelper.getClassLocalName(object.getClass());
    }

    public static @Nullable String getClassLocalName(@Nullable Class<?> clazz) {
        return clazz == null ? null : ClassHelper.getClassLocalName(clazz.getName());
    }

    public static @Nullable String getClassLocalName(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static @Nullable String getClassPackageName(@Nullable Object object) {
        return object == null ? null : ClassHelper.getClassPackageName(object.getClass());
    }

    public static @Nullable String getClassPackageName(@Nullable Class<?> clazz) {
        return clazz == null ? null : ClassHelper.getClassPackageName(clazz.getName());
    }

    public static @Nullable String getClassPackageName(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return n == -1 ? "" : string.substring(0, n);
    }

    public static @NonNull @Nonempty String getSafeClassName(@Nullable Object object) {
        if (object instanceof Class) {
            Class clazz = (Class)object;
            return clazz.getName();
        }
        if (object != null) {
            return object.getClass().getName();
        }
        return "null";
    }

    public static @Nullable String getDirectoryFromPackage(@Nullable Package package_) {
        return package_ == null ? null : ClassHelper.getPathFromClass(package_.getName());
    }

    public static @Nullable String getDirectoryFromPackage(@Nullable String string) {
        return ClassHelper.getPathFromClass(string);
    }

    public static @Nullable String getPathFromClass(@Nullable Class<?> clazz) {
        return clazz == null ? null : ClassHelper.getPathFromClass(clazz.getName());
    }

    public static @Nullable String getPathFromClass(@Nullable String string) {
        return string == null ? null : StringReplace.replaceAll(string, '.', '/');
    }

    public static @Nullable String getClassFromPath(@Nullable String string) {
        return string == null ? null : StringReplace.replaceMultipleAsString(string, new char[]{'\\', '/'}, '.');
    }

    protected static @NonNull String internalGetPathWithLeadingSlash(@NonNull @Nonempty String string) {
        return string.charAt(0) == '/' ? string : "/" + string;
    }

    public static @Nullable URL getResource(@NonNull Class<?> clazz, @NonNull @Nonempty String string) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassHelper.internalGetPathWithLeadingSlash(string);
        return clazz.getResource(string2);
    }

    static {
        ClassHelper._registerPrimitiveMapping(Boolean.TYPE, Boolean.class);
        ClassHelper._registerPrimitiveMapping(Byte.TYPE, Byte.class);
        ClassHelper._registerPrimitiveMapping(Character.TYPE, Character.class);
        ClassHelper._registerPrimitiveMapping(Double.TYPE, Double.class);
        ClassHelper._registerPrimitiveMapping(Float.TYPE, Float.class);
        ClassHelper._registerPrimitiveMapping(Integer.TYPE, Integer.class);
        ClassHelper._registerPrimitiveMapping(Long.TYPE, Long.class);
        ClassHelper._registerPrimitiveMapping(Short.TYPE, Short.class);
        INSTANCE = new ClassHelper();
    }
}

