/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.email;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.email.EmailAddressHelper;
import com.helger.base.email.IEmailAddress;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class EmailAddress
implements IEmailAddress {
    private final String m_sAddress;
    private final String m_sPersonal;

    public EmailAddress(@NonNull IEmailAddress iEmailAddress) {
        this(iEmailAddress.getAddress(), iEmailAddress.getPersonal());
    }

    public EmailAddress(@NonNull String string) {
        this(string, null);
    }

    public EmailAddress(@NonNull String string, @Nullable String string2) {
        ValueEnforcer.notNull(string, "EmailAddress");
        ValueEnforcer.isTrue(EmailAddressHelper.isValid(string), () -> "The passed email address '" + string + "' is illegal!");
        this.m_sAddress = EmailAddressHelper.getUnifiedEmailAddress(string);
        this.m_sPersonal = StringHelper.isEmpty(string2) ? null : string2;
    }

    @Override
    public @NonNull String getAddress() {
        return this.m_sAddress;
    }

    @Override
    public @Nullable String getPersonal() {
        return this.m_sPersonal;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EmailAddress emailAddress = (EmailAddress)object;
        return this.m_sAddress.equals(emailAddress.m_sAddress) && EqualsHelper.equals(this.m_sPersonal, emailAddress.m_sPersonal);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sAddress).append(this.m_sPersonal).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Address", this.m_sAddress).appendIfNotNull("Personal", this.m_sPersonal).getToString();
    }

    public static @Nullable EmailAddress createOnDemand(@Nullable String string) {
        return StringHelper.isEmpty(string) ? null : new EmailAddress(string);
    }

    public static @Nullable EmailAddress createOnDemand(@Nullable String string, @Nullable String string2) {
        return StringHelper.isEmpty(string) ? null : new EmailAddress(string, string2);
    }
}

