/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.ICharArrayEncoder;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import java.io.Writer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface ICharArrayStreamEncoder
extends ICharArrayEncoder {
    @Override
    @Nonnegative
    default public int getMaximumEncodedLength(@Nonnegative int n) {
        return n;
    }

    default public void encode(char @Nullable [] cArray, @WillNotClose @NonNull Writer writer) {
        if (cArray == null) {
            this.encode(null, 0, 0, writer);
        } else {
            this.encode(cArray, 0, cArray.length, writer);
        }
    }

    public void encode(char @Nullable [] var1, @Nonnegative int var2, @Nonnegative int var3, @WillNotClose @NonNull Writer var4);

    @Override
    @ReturnsMutableCopy
    default public char @Nullable [] getEncoded(char @Nullable [] cArray) {
        if (cArray == null) {
            return null;
        }
        return this.getEncoded(cArray, 0, cArray.length);
    }

    @Override
    @ReturnsMutableCopy
    default public char @Nullable [] getEncoded(char @Nullable [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(this.getMaximumEncodedLength(n2));){
            this.encode(cArray, n, n2, nonBlockingStringWriter);
            char[] cArray2 = nonBlockingStringWriter.getAsCharArray();
            return cArray2;
        }
    }

    @Override
    @ReturnsMutableCopy
    default public char @Nullable [] getEncoded(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        return this.getEncoded(cArray, 0, cArray.length);
    }

    default public @Nullable String getEncodedAsString(char @Nullable [] cArray) {
        if (cArray == null) {
            return null;
        }
        return this.getEncodedAsString(cArray, 0, cArray.length);
    }

    default public @Nullable String getEncodedAsString(char @Nullable [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(this.getMaximumEncodedLength(n2));){
            this.encode(cArray, n, n2, nonBlockingStringWriter);
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
    }

    default public @Nullable String getEncodedAsString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        return this.getEncodedAsString(cArray, 0, cArray.length);
    }
}

