/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.streamprovider;

import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStreamAndReader;
import com.helger.base.io.stream.ByteBufferInputStream;
import com.helger.base.tostring.ToStringGenerator;
import java.nio.ByteBuffer;
import org.jspecify.annotations.NonNull;

public class ByteBufferInputStreamProvider
implements IHasInputStreamAndReader {
    private final ByteBuffer m_aBuffer;

    public ByteBufferInputStreamProvider(@NonNull ByteBuffer byteBuffer) {
        this.m_aBuffer = ValueEnforcer.notNull(byteBuffer, "Buffer");
    }

    @ReturnsMutableObject
    public final @NonNull ByteBuffer getByteBuffer() {
        return this.m_aBuffer;
    }

    @Override
    public final @NonNull ByteBufferInputStream getInputStream() {
        return new ByteBufferInputStream(this.m_aBuffer);
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    public String toString() {
        return new ToStringGenerator(null).append("buffer", this.m_aBuffer).getToString();
    }
}

