/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec.impl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.base64.Base64;
import com.helger.base.codec.impl.AbstractRFC1522Codec;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class RFC1522BCodec
extends AbstractRFC1522Codec {
    public RFC1522BCodec() {
        this(StandardCharsets.UTF_8);
    }

    public RFC1522BCodec(@NonNull Charset charset) {
        super(charset);
    }

    @Override
    protected String getRFC1522Encoding() {
        return "B";
    }

    @Override
    @ReturnsMutableCopy
    protected byte @Nullable [] getEncoded(byte @Nullable [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return Base64.safeEncodeBytesToBytes(byArray, n, n2);
    }

    @Override
    @ReturnsMutableCopy
    protected byte @Nullable [] getDecoded(byte @Nullable [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return Base64.safeDecode(byArray, n, n2);
    }
}

